/*********************************************************************
 *
 * $Header: /usr0/robust/cvsroot/tutorial/SPHINX3/s3trainer/src/parallel_bw/baum_welch.h,v 1.1 2003/11/25 21:06:51 robust Exp $
 *
 * Carnegie Mellon ARPA Speech Group
 *
 * Copyright (c) 1995 Carnegie Mellon University.
 * All rights reserved.
 *
 *********************************************************************
 *
 * File: baum_welch.h
 * 
 * Description: 
 * 
 * Author: 
 * 	Eric H. Thayer
 *********************************************************************/

#ifndef BAUM_WELCH_H
#define BAUM_WELCH_H

#include <s3/prim_type.h>
#include <s3/vector.h>
#include <s3/state.h>
#include <s3/model_inventory.h>

int32
baum_welch_update(float64 *log_forw_prob,
		  vector_t **feature,
/* RSINGH: ADDITION FOR PARALLEL BW */
                  vector_t **feature2,
/* END ADDITION */
		  uint32 n_obs,
		  float32 ****spkr_xfrm_ainv,
		  float32  ***spkr_xfrm_b,
		  state_t *state,
		  uint32 n_state,
		  model_inventory_t *inv,
		  float64 a_beam,
		  float64 b_beam,
		  float32 spthresh,
		  int32 mixw_reest,
		  int32 tmat_reest,
		  int32 mean_reest,
		  int32 var_reest,
		  int32 pass2var,
		  int32 mllr_mult,
		  int32 mllr_add);

#endif /* BAUM_WELCH_H */ 


/*
 * Log record.  Maintained by RCS.
 *
 * $Log: baum_welch.h,v $
 * Revision 1.1  2003/11/25 21:06:51  robust
 * Adding the tutorial code (src for trainer, binaries for decoder
 * and trainer, scripts, other files needed).
 *
 * Revision 1.1.1.1  2002/05/10 16:51:46  robust
 * Initial port of tutorial into cvs.
 *
 * Revision 1.8  97/07/16  11:38:16  eht
 * *** empty log message ***
 * 
 * Revision 1.7  1996/07/29  16:21:12  eht
 * float32 -> float64
 *
 * Revision 1.6  1996/03/26  15:17:51  eht
 * Fix beam definition bug
 *
 * Revision 1.5  1996/02/02  17:42:39  eht
 * Pass both alpha and beta beams as input
 *
 * Revision 1.4  1995/11/30  20:52:00  eht
 * Allow tmat_reest to be passed as an argument
 *
 * Revision 1.3  1995/10/12  18:22:18  eht
 * Updated comments and changed <s3/state.h> to "state.h"
 *
 * Revision 1.2  1995/10/10  12:44:06  eht
 * Changed to use <s3/prim_type.h>
 *
 * Revision 1.1  1995/06/02  20:41:22  eht
 * Initial revision
 *
 *
 */
