/*********************************************************************
 *
 * $Header: /usr0/robust/cvsroot/tutorial/SPHINX3/s3trainer/src/mixw_interp/cmd_ln_defn.h,v 1.1 2003/11/25 21:06:51 robust Exp $
 *
 * CMU ARPA Speech Project
 *
 * Copyright (c) 1998 Carnegie Mellon University.
 * All rights reserved.
 *
 *********************************************************************
 *
 * File: cmd_ln_defn.h
 * 
 * Description: 
 * 	Command line definitions for bw
 *
 * Author: 
 * 	Eric Thayer (eht@cs.cmu.edu)
 *********************************************************************/

#ifndef CMD_LN_DEFN_H
#define CMD_LN_DEFN_H
    static arg_def_t defn[] = {

        { "-SImixwfn",
          CMD_LN_STRING,
          CMD_LN_NO_DEFAULT,
          "The SI mixture weight parameter file name"},

        { "-SDmixwfn",
          CMD_LN_STRING,
          CMD_LN_NO_DEFAULT,
          "The SD mixture weight parameter file name"},

/*
        { "-tokencntfn",
          CMD_LN_STRING,
          CMD_LN_NO_DEFAULT,
          "The token count file"},
*/

        { "-outmixwfn",
          CMD_LN_STRING,
          CMD_LN_NO_DEFAULT,
          "The output interpolated mixture weight parameter file name"},

        { "-SIlambda",
          CMD_LN_FLOAT32,
          "0.5",
          "Weight given to SI mixing weights" },

	{ NULL, CMD_LN_UNDEF, CMD_LN_NO_DEFAULT, NULL }
    };


#endif /* CMD_LN_DEFN_H */ 


/*
 * Log record.  Maintained by RCS.
 *
 * $Log: cmd_ln_defn.h,v $
 * Revision 1.1  2003/11/25 21:06:51  robust
 * Adding the tutorial code (src for trainer, binaries for decoder
 * and trainer, scripts, other files needed).
 *
 * Revision 1.1.1.1  2002/05/10 16:51:46  robust
 * Initial port of tutorial into cvs.
 *
 *
 */
