/*********************************************************************
 *
 * $Header: /usr0/robust/cvsroot/tutorial/SPHINX3/s3trainer/src/libio/read_line.c,v 1.1 2003/11/25 21:06:51 robust Exp $
 *
 * Carnegie Mellon ARPA Speech Group
 *
 * Copyright (c) 1995 Carnegie Mellon University.
 * All rights reserved.
 *
 *********************************************************************
 *
 * File: read_line.c
 * 
 * Description: 
 * 
 * Author: 
 * 	Eric H. Thayer (eht@cs.cmu.edu)
 *********************************************************************/

static char rcsid[] = "@(#)$Id: read_line.c,v 1.1 2003/11/25 21:06:51 robust Exp $";
#include <s3/read_line.h>
#include <s3/err.h>

#include <string.h>

char *
read_line(char *buf,
	  size_t max_len,
	  uint32 *n_read,
	  FILE *fp)
{
    char *out;
    int last;

    do {
	out = fgets(buf, max_len, fp);
	(*n_read)++;
    } while ((out != NULL) && (out[0] == '#'));

    if (strlen(buf) == (max_len-1)) {
	E_WARN("line %d may be truncated due to max_len==%d\n",
	       *n_read, max_len);
    }
    
    if (out != NULL) {
	last = strlen(out)-1;
    
	if (out[last] == '\n')
	    out[last] = '\0';
    }
    
    return out;
}

/*
 * Log record.  Maintained by RCS.
 *
 * $Log: read_line.c,v $
 * Revision 1.1  2003/11/25 21:06:51  robust
 * Adding the tutorial code (src for trainer, binaries for decoder
 * and trainer, scripts, other files needed).
 *
 * Revision 1.1.1.1  2002/05/10 16:51:45  robust
 * Initial port of tutorial into cvs.
 *
 * Revision 1.1  97/03/17  15:01:49  eht
 * Initial revision
 * 
 *
 */
