/*********************************************************************
 *
 * $Header: /usr0/robust/cvsroot/tutorial/SPHINX3/s3trainer/src/libio/fgets_wo_nl.c,v 1.1 2003/11/25 21:06:51 robust Exp $
 *
 * CMU ARPA Speech Project
 *
 * Copyright (c) 1997 Carnegie Mellon University.
 * All rights reserved.
 *
 *********************************************************************
 *
 * File: fgets_wo_nl.c
 * 
 * Description: 
 * 
 * Author: 
 * 
 *********************************************************************/

static char rcsid[] = "@(#)$Id: fgets_wo_nl.c,v 1.1 2003/11/25 21:06:51 robust Exp $";

#include <s3/fgets_wo_nl.h>
#include <s3/err.h>
#include <s3/prim_type.h>

#include <string.h>

char *
fgets_wo_nl(char *str,
	    size_t max,
	    FILE *fp)
{
    char *out;
    uint32 len;

    out = fgets(str, max, fp);

    if (out == NULL)
	return NULL;

    len = strlen(out);

    if (out[len-1] == '\n')
	out[len-1] = '\0';
    else {
	E_FATAL("input string too long.  Truncated.\n");

	return NULL;
    }

    return out;
}


/*
 * Log record.  Maintained by RCS.
 *
 * $Log: fgets_wo_nl.c,v $
 * Revision 1.1  2003/11/25 21:06:51  robust
 * Adding the tutorial code (src for trainer, binaries for decoder
 * and trainer, scripts, other files needed).
 *
 * Revision 1.1.1.1  2002/05/10 16:51:45  robust
 * Initial port of tutorial into cvs.
 *
 *
 */
