/*********************************************************************
 *
 * $Header: /usr0/robust/cvsroot/tutorial/SPHINX3/s3trainer/src/libcommon/ts2cb.c,v 1.1 2003/11/25 21:06:51 robust Exp $
 *
 * CMU ARPA Speech Project
 *
 * Copyright (c) 1997 Carnegie Mellon University.
 * All rights reserved.
 *
 *********************************************************************
 *
 * File: ts2cb.c
 * 
 * Description: 
 * 
 * Author: 
 * 
 *********************************************************************/

static char rcsid[] = "@(#)$Id: ts2cb.c,v 1.1 2003/11/25 21:06:51 robust Exp $";

#include <s3/ts2cb.h>
#include <s3/ckd_alloc.h>

uint32 *
semi_ts2cb(uint32 n_ts)
{
    return ckd_calloc(n_ts, sizeof(uint32));
    
}

uint32 *
cont_ts2cb(uint32 n_ts)
{
    uint32 *out, i;

    out = ckd_calloc(n_ts, sizeof(uint32));
    for (i = 0; i < n_ts; i++) {
	out[i] = i;
    }

    return out;
}



/*
 * Log record.  Maintained by RCS.
 *
 * $Log: ts2cb.c,v $
 * Revision 1.1  2003/11/25 21:06:51  robust
 * Adding the tutorial code (src for trainer, binaries for decoder
 * and trainer, scripts, other files needed).
 *
 * Revision 1.1.1.1  2002/05/10 16:51:45  robust
 * Initial port of tutorial into cvs.
 *
 * Revision 1.1  97/07/16  11:36:22  eht
 * Initial revision
 * 
 *
 */
