/*********************************************************************
 *
 * $Header: /usr0/robust/cvsroot/tutorial/SPHINX3/s3trainer/src/libclust/metric.c,v 1.1 2003/11/25 21:06:51 robust Exp $
 *
 * CMU ARPA Speech Project
 *
 * Copyright (c) 1997 Carnegie Mellon University.
 * All rights reserved.
 *
 *********************************************************************
 *
 * File: metric.c
 * 
 * Description: 
 * 
 * Author: 
 * 
 *********************************************************************/

static char rcsid[] = "@(#)$Id: metric.c,v 1.1 2003/11/25 21:06:51 robust Exp $";

#include <s3/metric.h>
#include <s3/div.h>

float64
wt_ent_inc(float32 **a,
	   float32 a_dnom,
	   float32 **b,
	   float32 b_dnom,
	   float32 **a_b,
	   uint32 n_stream,
	   uint32 n_density)
{
    return
	a_dnom * ddiv_d_state(a, a_b, n_stream, n_density) +
	b_dnom * ddiv_d_state(b, a_b, n_stream, n_density);
	
}


/*
 * Log record.  Maintained by RCS.
 *
 * $Log: metric.c,v $
 * Revision 1.1  2003/11/25 21:06:51  robust
 * Adding the tutorial code (src for trainer, binaries for decoder
 * and trainer, scripts, other files needed).
 *
 * Revision 1.1.1.1  2002/05/10 16:51:45  robust
 * Initial port of tutorial into cvs.
 *
 * Revision 1.1  97/07/16  11:36:22  eht
 * Initial revision
 * 
 *
 */
