/*********************************************************************
 *
 * $Header: /usr0/robust/cvsroot/tutorial/SPHINX3/s3trainer/src/libcep_feat/v3_feat.h,v 1.1 2003/11/25 21:06:51 robust Exp $
 *
 * CMU ARPA Speech Project
 *
 * Copyright (c) 1997 Carnegie Mellon University.  
 *   All rights reserved.
 *
 *********************************************************************
 *
 * File: v3_feat.h
 * 
 * Description: 
 * 
 * Author: 
 * 
 *********************************************************************/

#ifndef V3_FEAT_H
#define V3_FEAT_H


#include <s3/vector.h>

const char *
v3_feat_doc(void);

uint32
v3_feat_id(void);

uint32
v3_feat_n_stream(void);

uint32
v3_feat_blksize( uint32);

const uint32 *
v3_feat_vecsize( uint32);

void
v3_feat_set_in_veclen(uint32 len);

vector_t **
v3_feat_alloc(uint32 n_frames, uint32 veclen);

void
v3_feat_free(vector_t **f);

vector_t **
v3_feat_compute(vector_t *mfcc,
		uint32 *inout_n_frame, uint32 veclen);

void
v3_feat_print(const char *label,
	      vector_t **f,
	      uint32 n_frames, uint32 veclen);

#endif /* V3_FEAT_H */ 


/*
 * Log record.  Maintained by RCS.
 *
 * $Log: v3_feat.h,v $
 * Revision 1.1  2003/11/25 21:06:51  robust
 * Adding the tutorial code (src for trainer, binaries for decoder
 * and trainer, scripts, other files needed).
 *
 * Revision 1.1.1.1  2002/05/10 16:51:44  robust
 * Initial port of tutorial into cvs.
 *
 * Revision 1.1  97/07/16  11:38:16  eht
 * Initial revision
 * 
 *
 */
