/*********************************************************************
 *
 * $Header: /usr0/robust/cvsroot/tutorial/SPHINX3/s3trainer/src/libcep_feat/agc.c,v 1.1 2003/11/25 21:06:51 robust Exp $
 *
 * CMU ARPA Speech Project
 *
 * Copyright (c) 1994 Carnegie Mellon University.
 * All rights reserved.
 *
 *********************************************************************
 *
 * File: agc.c
 * 
 * Description: 
 * 	This routine does various kinds of automatic gain control (AGC).
 *
 *	BEWARE: This is hardcoded to 13 order cep via S2_CEP_VECLEN.
 *
 * Author: 
 * 	Eric H. Thayer (eht@cs.cmu.edu)
 *********************************************************************/

static char rcsid[] = "@(#)$Id: agc.c,v 1.1 2003/11/25 21:06:51 robust Exp $";

#include <s3/agc.h>
#include <s3/agc_max.h>
#include <s3/agc_emax.h>
#include <s3/r_agc_noise.h>

#include <s3/cmd_ln.h>
#include <s3/s2_param.h>	/* for S2_CEP_VECLEN */
#include <s3/err.h>

#include <string.h>

void
agc(float32 *mfcc,
    uint32 n_frame,
    uint32 veclen,
    char *agc_type)
{
    uint32 i;

    if (strcmp(agc_type, "noise") == 0) {
	real_agc_noise(mfcc, n_frame, veclen);
    }
    else if (strcmp(agc_type, "max") == 0) {
	agc_max(mfcc, n_frame, veclen);
    }
    else if (strcmp(agc_type, "emax") == 0) {
	for (i = 0; i < n_frame; i++) {
	    agc_emax_proc(&mfcc[i*veclen], &mfcc[i*veclen],
			  veclen);
	}
    }
    else if (strcmp(agc_type, "none") == 0) {
	/* do nothing */
    }
    else if (agc_type == NULL) {
	E_WARN("no agc set\n");
	return ;
    }
    else {
	E_FATAL("unsupported agc type %s\n", agc_type);
    }
}

/*
 * Log record.  Maintained by RCS.
 *
 * $Log: agc.c,v $
 * Revision 1.1  2003/11/25 21:06:51  robust
 * Adding the tutorial code (src for trainer, binaries for decoder
 * and trainer, scripts, other files needed).
 *
 * Revision 1.1.1.1  2002/05/10 16:51:44  robust
 * Initial port of tutorial into cvs.
 *
 * Revision 1.3  97/07/16  11:36:22  eht
 * *** empty log message ***
 * 
 * Revision 1.2  1996/03/25  15:34:23  eht
 * Deal w/ variable length input feature (e.g. MFCC) vector sizes.
 *
 * Revision 1.1  1995/12/14  20:12:58  eht
 * Initial revision
 *
 *
 */
