#!/bin/csh -f

source ../c_scripts/variables.def

if ($#argv != 2) then
   echo "usage: $0 <correct file> <hypothesis file>"
   exit 1
endif

set correct = $1
set hypothesis = $2

set tmpf1 = /tmp/xx1.$$
set tmpf2 = /tmp/xx2.$$
onintr cleanup
sed -e 's+_+ +g' -e 's+\.+ +g' -e 's+:m + +g' -e 's+:h + +g' -e 's+:c + +g' -e 's+:mi + +g' -e 's+:ma + +g' -e 's/++UM++/ /g' -e 's/++UH++/ /g' $hypothesis >! $tmpf2

set align = $bindir/align
$align  -def $correct \
	-hyp $tmpf2 \
	>&! $hypothesis.align

grep -i accuracy $hypothesis.align

cleanup:
/bin/rm -f $tmpf1 $tmpf2

exit 0

