#!/bin/csh -f

source ../variables.def

#***************************************************************************
# This script launches all the ci - continuous training jobs in the proper
# order. First it cleans up the directories, then launches the 
# flat initialization, and the baum-welch and norm jobs for the required
# number of iterations. Within each iteration it launches as many baumwelch
# jobs as the number of parts we wish to split the training into.
#***************************************************************************

if ($#argv > 2) then
    echo "USAGE: $0 <ngau> <iteration number (def 1)>"
    exit 0
endif

if ($#argv == 0) then
    echo "USAGE: $0 <ngau (def 1)> <iteration number (def 1)>"
    echo "Setting ngau to 1, iteration no. to 1"
    echo -n "Continue? (y/n) : "
    set ans = $<
    if ($ans != "y") exit 0
    echo "Assuming initial models are 1 gaussian per state"
    echo "Setting iter value to 1"
    set ngau = 1
    set iter = 1
else
    set ngau = $1
    set iter = $2
endif

set scriptdir = $base_dir/c_scripts/05.cd-chmm
set qmgrdir   = $base_dir//qmanager
if (! -e $qmgrdir) mkdir -p $qmgrdir
set logdir = $base_dir//logdir/05.cd_chmm
if ( ! -e $logdir ) mkdir -p $logdir        
set bwaccumdir = $base_dir//bwaccumdir
set modeldir  = $base_dir//model_parameters

#Read npart from variables.def

# Clean up junk from earlier runs
echo "Cleaning up accumulator directories..."
/bin/rm  -f $bwaccumdir/${exptname}_buff_*/*

if ($iter == 1 && $ngau == 1) then
    echo "Cleaning up log directories..."
    /bin/rm -rf $logdir
    mkdir -p $logdir
    echo "Cleaning up qmanager directories..."
    /bin/rm -rf $qmgrdir
    mkdir -p $qmgrdir
endif

if ($iter == 1 && $ngau == 1) then
    # For the first iteration Flat initialize models.
    # To start off queue trap job id
    set errfn = $qmgrdir/$exptname.initialize_cdtied.err
    set outfn = $qmgrdir/$exptname.initialize_cdtied.out
    set normjob_name = $exptname.init
    set normjob_id = `${QSUB} -q $qtype -r -R "type==any" -J $normjob_name -e $errfn -o $outfn $scriptdir/initialize.cd.csh | awk '{print $2}' | sed -e 's+<++g' -e 's+>++g'`
    echo "$normjob_name = $normjob_id submitted"

    set partid = 1
    set errfn = $qmgrdir/$exptname.bw.cdtied.$iter.$partid.err
    set outfn = $qmgrdir/$exptname.bw.cdtied.$iter.$partid.out

    # Submit job and store id
    set bwjob_name = ${exptname}${ngau}.$iter.$partid
    set bwjob_id = `${QSUB} -q $qtype -r -R "type==any" -J $bwjob_name -w $normjob_id -e $errfn -o $outfn $scriptdir/baum_welch.csh $ngau $iter $partid $npart| awk '{print $2}' | sed -e 's+<++g' -e 's+>++g'`
    echo "$bwjob_name = $bwjob_id submitted"

    set bwjids = $bwjob_id

    @   partid = $partid + 1
    while ($partid <= $npart)
	set errfn = $qmgrdir/$exptname.bw.cdtied.$iter.$partid.err
	set outfn = $qmgrdir/$exptname.bw.cdtied.$iter.$partid.out

        # Submit job and store id
        set bwjob_name = ${exptname}${ngau}.$iter.$partid
        set bwjob_id = `${QSUB} -q $qtype -r -R "type==any" -J $bwjob_name -w $normjob_id -e $errfn -o $outfn $scriptdir/baum_welch.csh $ngau $iter $partid $npart| awk '{print $2}' | sed -e 's+<++g' -e 's+>++g'`
        echo "$bwjob_name = $bwjob_id submitted"
	set bwjids = `echo "$bwjids && $bwjob_id"`

@	partid = $partid + 1
    end

    set errfn = $qmgrdir/$exptname.norm.cdtied.$iter.err
    set outfn = $qmgrdir/$exptname.norm.cdtied.$iter.out

    # Run norm only if all the bw jobs have run
    set normjob_name = $exptname.$iter.norm
    
    set normjob_id = `${QSUB} -q $qtype -R "type==any" -r -J $normjob_name -w "${bwjids}" -e $errfn -o $outfn $scriptdir/norm_and_launchbw.csh $ngau $iter | awk '{print $2}' | sed -e 's+<++g' -e 's+>++g'`
    echo "$normjob_name = $normjob_id submitted"
    touch $logdir/$JobSubmitted

    exit 0
endif

set partid = $npart
set errfn = $qmgrdir/$exptname.bw.cdtied.$iter.$partid.err
set outfn = $qmgrdir/$exptname.bw.cdtied.$iter.$partid.out

# Submit job and store id
set bwjob_name = ${exptname}${ngau}.$iter.$partid
set bwjob_id = `${QSUB} -q $qtype -r -R "type==any" -J $bwjob_name -e $errfn -o $outfn $scriptdir/baum_welch.csh $ngau $iter $partid $npart| awk '{print $2}' | sed -e 's+<++g' -e 's+>++g'`
echo "$bwjob_name = $bwjob_id submitted"

set bwjids = $bwjob_id

@   partid = $partid - 1
while ($partid >= 1)
    set errfn = $qmgrdir/$exptname.bw.cdtied.$iter.$partid.err
    set outfn = $qmgrdir/$exptname.bw.cdtied.$iter.$partid.out

    # Submit job and store id
    set bwjob_name = ${exptname}${ngau}.$iter.$partid
    set bwjob_id = `${QSUB} -q $qtype -r -R "type==any" -J $bwjob_name -e $errfn -o $outfn $scriptdir/baum_welch.csh $ngau $iter $partid $npart| awk '{print $2}' | sed -e 's+<++g' -e 's+>++g'`
    echo "$bwjob_name = $bwjob_id submitted"
    set bwjids = `echo "$bwjids && $bwjob_id"`

@    partid = $partid - 1
end

set errfn = $qmgrdir/$exptname.norm.cdtied.$iter.err
set outfn = $qmgrdir/$exptname.norm.cdtied.$iter.out

# Run norm only if all the bw jobs have run
set normjob_name = $exptname.$iter.norm
    
set normjob_id = `${QSUB} -q $qtype -R "type==any" -r -J $normjob_name -w "${bwjids}" -e $errfn -o $outfn $scriptdir/norm_and_launchbw.csh $ngau $iter | awk '{print $2}' | sed -e 's+<++g' -e 's+>++g'`
echo "$normjob_name = $normjob_id submitted"

exit 0
