#! /usr/local/bin/tcsh -f

source ../variables.def

#*************************************************************************
# This script runs the build_tree script for each state of each basephone
#*************************************************************************

set scriptdir = $base_dir/c_scripts/03.buildtrees
set qmgrdir = $base_dir/qmanager
set logdir = $base_dir/logdir/03.buildtrees
if ( ! -e $logdir ) mkdir -p $logdir
/bin/rm -rf $logdir
/bin/rm -rf $qmgrdir
mkdir -p $logdir
mkdir -p $qmgrdir
set killfile = $qmgrdir/03.buildtrees.killfile
touch $killfile

#$phonefile obtained from variables.def
#$statesperhmm obtained from variables.def

if ($run_all) then

# compute number of phones
    set n_phones = `wc -l $phonefile | awk '{print $1}'`
    set n_filler_phones = `awk '{for (i=2; i<=NF; i++) print $i}' $fillerdict | sort -u | wc -l`
    @ n_ci_phones = $n_phones - $n_filler_phones

# compute number of jobs
    @ n_jobs = $n_ci_phones * $statesperhmm

# launch next step
    set nextscriptdir = $base_dir/c_scripts/04.tiestate
    set errfile = $qmgrdir/slave.04.err
    set outfile = $qmgrdir/slave.04.out
    set nextjid = `${QSUB} -q $qtype -W depend=on:$n_jobs -r -e $errfile -o $outfile $nextscriptdir/slave_tiestate.csh | awk '{print $2}' | sed -e 's+<++g' -e 's+>++g'`
    set nextdep = "-W depend=beforeok:${nextjid}"
else
    set nextdep = ""
endif

set dependchain = "";
foreach phone (`cat $phonefile`)
    set state = 0
    while ( $state < $statesperhmm )
        set errfile = $qmgrdir/buildtree.$phone.$state.err
        set outfile = $qmgrdir/buildtree.$phone.$state.out
        set bldjid = `${QSUB} -q $qtype $nextdep -W depend=on:1 -r -e $errfile -o $outfile $scriptdir/build_tree.csh $phone $state | awk '{print $2}' | sed -e 's+<++g' -e 's+>++g'`
	set dependchain = "${dependchain} -W depend=beforeok:${bldjid}"
	echo "Phone = $phone, State = $state - $bldjid submitted"
        echo "${QDEL} $bldjid" >> $killfile
    @   state = $state + 1
    end
end

set errfile = $qmgrdir/make_quest.err
set outfile = $qmgrdir/make_quest.out
set questjid = `${QSUB} -q $qtype ${dependchain} -r -e $errfile -o $outfile $scriptdir/make_questions.csh | awk '{print $2}' | sed -e 's+<++g' -e 's+>++g'`
echo "${QDEL} $questjid" >> $killfile
echo "Question Maker $questjid submitted"

chmod +x $killfile

touch $logdir/$JobSubmitted

exit 0
