// vecmath.h
// Vector class and math operations for physics programs.
// by Greg Reshko
// 12/06/1999

double const PI = 3.14159265359;

class vector {
	public:
	double x, y;
	vector() {x=0; y=0;}									// vector A
	vector(double tempx, double tempy) {	// vector A(x,y)
		x=tempx; y=tempy; }
	vector operator+(vector a) {					// A = B + C
		x += a.x; y += a.y;
		return *this; }
	vector operator-(vector a) {					// A = B - C
		x -= a.x; y -= a.y;
		return *this; }
	vector operator*(double k) {					// A = B * k
		x *= k; y *= k;
		return *this; }
	double operator*(vector a) {					// k = B * C (dot product)
		return (x*a.x + y*a.y); }
	double Norm(void) {
		return (sqrt(x*x+y*y));	}
	void Set(double tempx, double tempy) {	// A.Set(x,y)
		x=tempx; y=tempy; }
};

