DWord  PilotMain (Word cmd, Ptr cmdPBP, Word launchFlags) {
  short error;
  if (cmd == sysAppLaunchCmdNormalLaunch) {
  	error = StartApplication();
    if (error) return error;
    EventLoop();
    StopApplication (); }
  return 0;
}

// main event loop
static void EventLoop() {
  EventType e;
  unsigned short err, formID;
  FormType* form;
  do {
    EvtGetEvent(&e,-1);
    if (SysHandleEvent(&e)) continue;
    if (MenuHandleEvent((void *)0, &e, &err)) continue;
    if (e.eType == frmLoadEvent) {
      formID = e.data.frmLoad.formID;
      form=FrmInitForm(formID);
      FrmSetActiveForm(form);
      switch (formID) {
        case Form1: FrmSetEventHandler(form, (FormEventHandlerPtr) Form1Handle);
        break; }}
    FrmDispatchEvent(&e);
  } while(e.eType != appStopEvent);
}


// find and open MathLib library
// find and open serial port
// open Form1
static int StartApplication() {
  Err error;
	error = SysLibFind(MathLibName, &MathLibRef);
	if (error)
    error = SysLibLoad(LibType, MathLibCreator, &MathLibRef);
	ErrFatalDisplayIf(error, "Can't find MathLib");
	error = MathLibOpen(MathLibRef, MathLibVersion);
	ErrFatalDisplayIf(error, "Can't open MathLib"); 
  SysLibFind("Serial Library", &portRef);
  SerOpen(portRef, 0, 9600);
  FrmGotoForm(Form1);
  return 0;
}

// Stop Application:
// close MathLib library and close serial port
static void StopApplication () {
	Err error;
  UInt usecount;
	error = MathLibClose(MathLibRef, &usecount);
	ErrFatalDisplayIf(error, "Can't close MathLib");
	if (usecount == 0)
    SysLibRemove(MathLibRef); 
  SerClose(portRef);
}

static Boolean Form1Handle(EventPtr event) {
	Boolean Handled=false;
    switch (event->eType) {
    	case frmOpenEvent:
    		Handled=true;
        FrmDrawForm(FrmGetActiveForm());
				break;
      case nilEvent: 
       	Handled=true;
        break;
	    case ctlSelectEvent:
        switch (event->data.ctlSelect.controlID) {
         	// Click: Forward Button
					case Form1FwdButton:
						SndPlaySystemSound(sndAlarm);												
						k+=10;
						Display(k);
 						break;
					// Click: "Stop" button
					case Form1StopButton:
						DisplayTxt("Stop");				
						SndPlaySystemSound(sndConfirmation);												
						Drive(0,0,0);
						break;
					// Click: IRScan button
					case Form1IRScanButton:
						DisplayIR1(Sensor_To_Range(Sensor(1)));
						DisplayIR2(Sensor_To_Range(Sensor(2)));
						break;
					// Click: "Wandering" button
					case Form1DriveWTButton:
						SndPlaySystemSound(sndAlarm);												
						TravelerAlgorithm();
						break;
					// Click: "Move & Spin" button
					case Form1MoveSpinButton:
						SpinAlgorithm();
						break;
					// Click: "Target Follow" button
					case Form1TargetFollowButton:
						PenFollowAlgorithm();
						break;
					// Click: "Wall Follow" button
					case Form1WFollowButton:
						WallFollowAlgorithm();
						break; }
	      Handled=true;
        break;
	    default:
	    	FrmHandleEvent(FrmGetActiveForm(), event);
	    	Handled=true;
	    	break;
  }
  return Handled;
}
