// sv203.c   
// ****************************************************
// File: sv203.c
// Date: 11/11/2001
// Last modified: 11/13/2001
// Author: Karl McEntire
// Program: Palm communication to sv203 servo control board
// ****************************************************


portOpen() {
	int ret;
	ret = seropen(9600, "8N1N", 100);
//	if (ret == 0 ) 
//		puts("serial port is open\n");
//	else
//    	puts("serial port err\n");
	return ret ;
}

portClose() {
	serclose() ;
//	puts("serial port is closed\n");
}

//Transmit command and its parameter to board

Tx(string cmd, int para) {
   char cCmd[15];
   string  sCmd ;
   pointer pcCmd;
   int cr;
   cr = 13;
   pcCmd = &cCmd;
   sCmd = cmd + (string)para ; 		// the integer 'para' is cast to string and appended to cmd
   strtoc(sCmd, pcCmd);  			// convert string to char - store at pointer
   sersenda(pcCmd, strlen(sCmd));	// send the command to the serial port
   sersend(cr);						// send a carriage return
   sleep(50); 						// allow time for cmd to go 
} 

TxString(string cmd) {
   char cCmd[22];
   string  sCmd ;
   pointer pcCmd;
   int cr;
   cr = 13;
   pcCmd = &cCmd;
   sCmd = cmd ; 					// 
   strtoc(sCmd, pcCmd);  			// convert string to char - store at pointer
   sersenda(pcCmd, strlen(sCmd));	// send the command to the serial port
   sersend(cr);						// send a carriage return
   sleep(50); 						// allow time for cmd to go 
} 
	


// Receive a string from the sv203 board

Rc() {

	/********************************************************** 
	   Sampling of sensors is done by sending a request to 
	   sample a desired sensor ("AD1"), and then receiving 
	   a one byte 0-255 value of the sensor followed by 
	   ASCII 10 and ASCII 13.
	***********************************************************/
	
    int len, data, i ;
    char cBuf[10];
    pointer pcBuf, pdata ;
    pcBuf = &cBuf;
    len = serdata();

	if (len) {						// is not zero then data is waiting

		serrecva(pcBuf, len);  		// put data into buffer

		cBuf[len-2] = 0 ;			// this puts a zero after the last ASCII number
									// the zero tells the ctostr function when to stop
									
		data = (int)ctostr(pcBuf);	// convert the char array to a string
									// then cast the string to an integer

		return data;				// return the integer value
	}								// endif
}									// return

