// servo.c   
// ****************************************************
// File: servo.c
// Date: 11/13/2001
// Last modified: 12/09/2001
// Author: Karl McEntire
// Program: Calculations for the bot servos
// ****************************************************

#define svoMaxRevs 1.1


int RevToVal(float rev) {
	if ( rev < -svoMaxRevs ) 		// don't allow servos to execeed max
		rev = -svoMaxRevs ;
	if ( rev > svoMaxRevs ) 
		rev = svoMaxRevs ;

	return (int)( 20.0*rev*rev*rev - 4.0*rev*rev + 15.0*rev + 129 );
	// see Excel spread sheet "Servo Motor Measurements 2.xls" for coefficients

}



