// frogWallFol.c
// ****************************************************
// File: frogWallFol.c
// Date: 11/27/2001
// Last modified: 02/16/2002
// Author: Karl McEntire
// Program: Wall follow right using a leap frog idea.
//			When sensor x is at distance d from wall
//			stop wheel to right and spin the other two
//			wheels until until the next sensor is at d.
// ****************************************************

//Setup ID numbers
#define frogFORM 	4000
#define startBUTTON 4001
#define exitBUTTON 	4002
#define instructLBL1 4030
#define instructLBL2 4031
#define instructLBL3 4032

froggy() {
	int dmin, state, cnt = 0 ;
	int vel = 100 ;  // turn servo motor CW 0.87 rev / sec

	dmin = 60 ; // min distance away from wall
	state = 0 ; // look for sensor one to begin with

	while( 2 != event(2) ) { 	// continue until pen down event
		switch( state ) {
			case 0:			
				if( IrVal( 1 ) >= dmin )
					Drive( vel, vel, 0 ) ;
				break ;
			case 1:
				if( IrVal( 2 ) >= dmin )
					Drive( 0, vel, vel ) ;
				break ;
			case 2:
				if( IrVal( 3 ) >= dmin )
					Drive( vel, 0, vel ) ;
				break ;
		}
		cnt++ ;
		state = cnt % 3  ;
	}
}


frogWallFol() {
	int e;

	Form(frogFORM,"Frogger Wall Follow");
	
	//buttons	
	Button(exitBUTTON,0x10,120,140,0,0,"Exit");
	Button(startBUTTON,0x00,40,140,0,0,"Start");
	Label(instructLBL1,10,60,"Place bot with sensor 1 next to wall.");
	Label(instructLBL2,20,70,"Tap Start button to begin.");
	Label(instructLBL3,30,80,"Tap screen to stop.");

	Fctl(DRAW,frogFORM); //draw objects

	while(1) {
		e=Fevent(1);
		switch(e) {
			case exitBUTTON: 
				StopRobot();
				return;
			case startBUTTON: 
				portOpen() ;
				froggy();
				StopRobot();		
				portClose();
				break;
		}
	}
}