// PPRKMemo.c
//************************************************
// File: PPRKMemo.c
// Date: 11/22/2001
// Last modified: 02/16/2002
// Author: Karl McEntire
// Program: Read a canned pattern from a memo file and
// follow it.
// ****************************************************

//Setup ID numbers
#define memoFORM 			8000
//#define memoStartBUTTON 	8001
#define memoExitBUTTON 		8002
#define circleBUTTON 		8003
#define orbitBUTTON 		8004
#define squareBUTTON 		8005
#define diagBUTTON 			8006
#define triangeBUTTON 		8007
#define straightBUTTON 		8008
#define cirspinBUTTON 		8009
#define diagspinBUTTON 		8010

#define memoInstructLBL1 	8030
#define memoInstructLBL2 	8031

#define memoFIELD		 	8050

read() {
  int i;
  string data[200];
  int ndata;
  int startTime ; 
  string memo ;

  memo = mmgetl();    							// read title
  FsetText( memoFIELD, "Reading " + memo );

  while (! mmeof() )   					// read a line at a time
    data[ndata++] = mmgetl();
  mmclose();    						// close the memo

  FsetText( memoFIELD, "Entries: " + ndata );
  sleep(500);

  // output the data to the PPRK
  portOpen();
  startTime = ticks() ;

  for (i = 0; i < ndata; i++) { 
    TxString( data[i] );
	sleep( 130 );						// set a delay until the next cmd
    FsetText( memoFIELD, "Running " + memo + " " + i + " of " + ndata );
  }

  portClose();
  
  FsetText( memoFIELD, "msec/cmd: " + (( ticks() - startTime ) / ndata ));
  sleep(500);
  FsetText( memoFIELD, "Done! Try another");
}


PPRKMemo() {
  	string memo ;
 	int e;
		
	Form(memoFORM,"Pattern Follow  ");

	//buttons	
	Button(memoExitBUTTON,0x10,120,140,0,0,"Exit");
	Button(circleBUTTON,0x00,10,40,0,0,"Circle");
	Button(orbitBUTTON,0x00,10,60,0,0,"Orbit");
	Button(squareBUTTON,0x00,10,80,0,0,"Square");
	Button(diagBUTTON,0x00,80,40,0,0,"Diagonal");
	Button(triangeBUTTON,0x00,80,60,0,0,"Triangle");
	Button(straightBUTTON,0x00,80,80,0,0,"Straight");
	Button(cirspinBUTTON,0x00,80,100,0,0,"Circle & Spin");
	Button(diagspinBUTTON,0x00,10,100,0,0,"Diag & Spin");

	// labels
	Label(memoInstructLBL1,10,20,"Bot follows a pattern in a memo file");
	Label(memoInstructLBL2,30,120,"Tap button to begin");

	// fields
	Field(memoFIELD,0x110,5,140,110,16,64,"");


	Fctl(DRAW,memoFORM); //draw objects

	while(1) {
		e=Fevent(1);
		switch(e) {
			case memoExitBUTTON: 
				StopRobot();
				return;
			case circleBUTTON: 		memo = "Circle" ; 	break ;
			case cirspinBUTTON: 	memo = "Cirspin" ; 	break ;
			case diagBUTTON: 		memo = "Diag" ; 	break ;
			case diagspinBUTTON: 	memo = "Diagspin" ; break ;
			case orbitBUTTON: 		memo = "Orbit" ; 	break ;
			case squareBUTTON: 		memo = "Square" ; 	break ;
			case straightBUTTON: 	memo = "Straight" ; break ;
			case triangeBUTTON: 	memo = "Tri" ; 		break ;
		}
		
		FsetText( memoFIELD, "Opening " + memo );
	  	if ( mmfind( memo) ) read() ;
  		else FsetText( memoFIELD, "Error with " + memo );
	}
}
