// Holonomonic.c
//************************************************
// File: Holonomic.c
// Date: 11/22/2001
// Last modified: 02/17/2001
// Author: Karl McEntire
// Program: Algorithm to demo holonomic movement 
// ****************************************************

//Setup ID numbers
#define holoFORM 			9000
#define holoStartBUTTON 	9001
#define holoExitBUTTON 		9002

#define holoInstructLBL1 	9030
#define holoInstructLBL2 	9031
#define holoInstructLBL3 	9032

#define velLBL 				9040
#define headLBL 			9041
#define omegaLBL 			9042
#define durLBL 				9043

#define velFIELD			9050
#define headFIELD 			9051
#define omegaFIELD			9052
#define durFIELD 			9053


//  run bot in a direction, speed, and rotation for the duration
Holo(string vel, string sHead, string sOmega, string sDuration ) {

	float vel, heading, omega, dur ;
	float velX, velY, tElapsed ;  
	int startTime ;
	
	heading = (float)sHead / 360 * 2 * PI ;
	dur = (float)sDuration * 100 ;
	omega = (float)sOmega / 60 * 2 * PI ;

	velX = sin(heading) * (float)vel ;
	velY = cos(heading) * (float)vel ;
	startTime = ticks();

	while (startTime + dur > ticks()) {
		holoDriver( velX, velY, omega, tElapsed ) ;
		tElapsed = ( ticks() - startTime ) / 100.0 ;  // seconds
	}
}

Holonomic() {
	int e;
	string vel, head, omega, dur ;
	
	
	Form(holoFORM,"Holonomic Motion       ");
	
	//buttons	
	Button(holoExitBUTTON,0x10,120,140,0,0,"Exit");
	Button(holoStartBUTTON,0x00,40,140,0,0,"Start");

	//fields (editable, underline)
	Field(velFIELD,  0x00,120, 50,25,16,64,"4.0");
	Field(headFIELD, 0x00,120, 70,25,16,64,"45");
	Field(omegaFIELD,0x00,120, 90,25,16,64,"1.5");
	Field(durFIELD,  0x00,120,110,25,16,64,"20");

	// labels
	Label(holoInstructLBL1,10,15,"Bot will demo holonomic motion.");
	Label(holoInstructLBL2,20,25,"Tap Start button to begin.");
	Label(holoInstructLBL3,5,35,"Edit fields to change default settings.");
	Label(velLBL,  10, 50, "Velocity (in/sec):");
	Label(headLBL, 10, 70, "Heading (degrees):");
	Label(omegaLBL,10, 90, "Rotation Vel (rot/min):");
	Label(durLBL,  10,110, "Duration (sec):");
		
	Fctl(DRAW,holoFORM); //draw objects

	while(1) {
		e=Fevent(1);
		switch(e) {
			case holoExitBUTTON: 
				StopRobot();
				return;
			case holoStartBUTTON:
				vel = FgetText(velFIELD);
				head = FgetText(headFIELD);
				omega = FgetText(omegaFIELD);
				dur = FgetText(durFIELD);
				portOpen() ;
				Holo( vel, head, omega, dur );
				StopRobot() ;
				portClose() ;
				break;
		}
	}
}


