// *************************************************************
// The Robotics Institute
// Carnegie Mellon University
// Copyright (C) 2000 by RI.
// All Rights Reserved.
//
// File: 					vecmath.h
// Project: 			PalmPilot Robot source code (Advanced project)
// Author: 				Greg Reshko
// Last modified: 12/06/1999
// Program:
// Vector class and math operations.
// *************************************************************

double const PI = 3.14159265359;

class vector {
	public:
	double x, y;
	vector() {x=0; y=0;}										// vector A
	vector(double tempx, double tempy) {		// vector A(x,y)
		x=tempx; y=tempy; }
	vector operator+(vector a) {						// A = B + C
		x += a.x; y += a.y;
		return *this; }
	vector operator-(vector a) {						// A = B - C
		x -= a.x; y -= a.y;
		return *this; }
	vector operator*(double k) {						// A = B * k
		x *= k; y *= k;
		return *this; }
	double operator*(vector a) {						// k = B * C (dot product)
		return (x*a.x + y*a.y); }
	double Norm(void) {											// ||A||
		return (sqrt(x*x+y*y));	}
	void Set(double tempx, double tempy) {	// A.Set(x,y)
		x=tempx; y=tempy; }
};

