// *************************************************************
// The Robotics Institute
// Carnegie Mellon University
// Copyright (C) 2000 by RI.
// All Rights Reserved.
//
// File: 					sv203.cpp
// Project: 			PalmPilot Robot source code (Advanced project)
// Author: 				Greg Reshko
// Last modified: 4/03/2000
// Program:
// Implementation of SV203 class defined in sv203.h
// *************************************************************

#ifndef __SV203_CPP__
#define __SV203_CPP__
#include "sv203.h"	

// default constructor
SV203::SV203 () {
  SysLibFind("Serial Library", &portRef);	// find serial library
  SerOpen(portRef, 0, 9600);							// open COM port
}

// default destructor
SV203::~SV203 () {
  SerClose(portRef);											// close COM port
}

// transmit command and its parameter to board
void SV203::Tx(char *command, int parameter) {
  Err error;
  char prm_buffer[]="    ";																	// parameter buffer
  StrPrintF(prm_buffer, "%d\r", parameter);									// store param and '\r' into buffer
  SerSendWait(portRef, -1); 						 										// wait for port to clear
  SerSend(portRef, command, StrLen(command), &error); 			// send buffer
  SerSendWait(portRef, -1); 						 										// wait for port to clear
  SerSend(portRef, prm_buffer, StrLen(prm_buffer), &error); // send buffer
  
}

// receive string from board
void SV203::Rc(char *buffer) {
	Err error;
	// receive from portRef into incoming buffer using 5 bytes and 3ms timeout
	SerReceive(portRef, buffer, 4, 10, &error);	// receiver buffer
	SerReceiveFlush(portRef, 5); 								// flush receive buffers
	SerSendFlush(portRef);											// flush send buffers
}


#endif __SV203_CPP__