package banyan

import scala.actors.Actor
import scala.actors.AbstractActor
import scala.actors.Actor._

import scala.actors.remote.RemoteActor
import scala.actors.remote.RemoteActor._
import scala.actors.remote._

import java.net.InetAddress

import org.apache.commons.cli.Options
import org.apache.commons.cli.CommandLine


import BanyanPublic._
import BanyanPrivate._


private object Coordinator {
  
  def parse(args: Array[String]) : CommandLine = {

    //use CLI to parse command line options
    var opts = new org.apache.commons.cli.Options();
    opts.addOption("t", true, "worker target");
    opts.addOption("cp", true, "coordinator port (default = 9500)");
    //do parsing
    var parser = new org.apache.commons.cli.GnuParser();
    parser.parse( opts, args);

  }



//  type HostData = Tickets

//  var hostList: List[(Host, HostData)] = Nil
  var hostMap: scala.collection.mutable.HashMap[Host,HostData] = 
    new scala.collection.mutable.HashMap[Host,HostData]()
  var nextID = "A"

  val startTime = System.currentTimeMillis()

  def timeSinceStart(): Long = 
    System.currentTimeMillis() - startTime

  def freest() : (Host, HostData) = {
    val hostList 
      = hostMap.toList.sort((e1, e2) => e1._2.surplus < e2._2.surplus)
    
    err.println("sorted list: " + hostList.toString);
    hostList.head
  }


  def increment(c: Char) : Char = {
    c match {
      case x if ('A' <= x && x < 'Z') =>  (x+1).toChar
      case x if (x == 'Z') => 'a'
      case x if ('a' <= x && x < 'z') => (x+1).toChar
      case x if (x == 'z') => '0'
      case x if ('0' <= x && x < '9') => (x+1).toChar
      case x if (x == '9') => 'A'
    }
  }


  def rollOver(l: List[Char]) : List[Char] = {
    var list = l
    if(l.isEmpty)
      List('A')
    else {
      var next = increment(list.last)
      list = if (next == 'A') rollOver(list.dropRight(1))
          else list.dropRight(1)
      list ++ List(next)
    }   
  }


  def getNewID() : String = {
    val tempID = nextID
    var list = nextID.toCharArray.toList
    var last = list.last
    list = rollOver(list)
    nextID = ""
    for(i<-list.indices) nextID += list(i).toString

    tempID
  }  

  def printHostMap(): Unit = {
    for((k,HostData(v,t)) <- hostMap) {
      print( v +"\t")
    }
    println()
  }


  def main(args: Array[String]) {


    val cmd = parse(args)
    
    //process options

    var workerTarget: Tickets = 
//      if (!cmd.hasOption("t")) {
//        1000
//      } else {
        java.lang.Integer.parseInt(cmd.getOptionValue("t", "1000"))
//      }

               





    val err = System.err

    var grandTotalTickets: Tickets = 0
    var ticketsHere: Tickets = 0
//    var workerTarget: Tickets = 1000


    val me = InetAddress.getLocalHost()
    err.println("me = " + me.toString)
    err.println("workerTarget = " + workerTarget)

    val coor_prt =         
      java.lang.Integer.parseInt(cmd.getOptionValue("cp", "9500"))

  // should use ports in range 49152 - 65535    

    actor {
      
      alive(coor_prt)
      register('coordinator, self)

      err.println("port is alive")


      loop {

        react {
	  case ('registerWorker, hst: Host) =>
            hostMap.put(hst, HostData(0,workerTarget))

            
	    err.println ("got new host. map is now: ")
            err.println(hostMap.toString)
            grandTotalTickets += workerTarget
            ticketsHere += workerTarget
            sender ! ('registered, getNewID(), workerTarget)

	  case('deregisterWorker, hst: Host) =>
            hostMap.removeKey(hst)
	    //print error if not found
	    err.println("removed host: "+hostMap.toString)

          case ('registerClient) =>
            if(ticketsHere > 0) {
              val t = ticketsHere
              ticketsHere = 0
              val (bestHost, hd) = freest()
              reply('registered, t, bestHost) 
              
            } else {
              throw new Error("multiple clients feature: unimplemented")
            }

          case ('deregisterClient, t: Tickets) =>
            err.println("client done")
            ticketsHere += t

	  case('haveSurplus, hst: Host, 
               hd: HostData,
               subtreeTickets: Tickets) =>
            err.println("got haveSurplus message from " + hst)
            hostMap.put(hst, hd)
            err.println(hostMap)
            println(hst + "\t" + timeSinceStart() + "\t" + hd.tickets)

            val surplus = hd.surplus
            //find a worker that can best handle this subtree
            val (bestHost, best_hd) = freest()
            val biggestDeficit = best_hd.surplus 
            if(biggestDeficit < 0 
               &&  surplus > subtreeTickets + biggestDeficit ){
              reply('assignment, bestHost)
            } else {
              err.println("noAssignment. biggestDeficit = " + biggestDeficit)
              err.println("subtreeTickets = " + subtreeTickets)
              reply('noAssignment)
            }
	    err.println("Map is now: " + hostMap.toString)
//            printHostMap()

	  case('update, hst: Host, hdata: HostData) =>
            err.println("got update message from " + hst)
            hostMap.put(hst, hdata)
            err.println(hostMap)
  //          printHostMap()
            println(hst + "\t" + timeSinceStart() + "\t" + hdata.tickets)

          case 'quit =>
            for(w <- hostMap.keys){
              val a = select(w, 'worker)
              a ! 'quit
            }
            exit

	  case msg =>
	    err.println("got unknown message: "+ msg)
	}
      }

    }

  }
}


