// The Robotics Institute
// Carnegie Mellon University
// Copyright (C) 2000 by RI.
// All Rights Reserved.

// File: 					servotest.cpp
// Project: 			PalmPilot Robot source code (TestRobot project)
// Author: 				Greg Reshko
// Last modified: 2/28/2000
// Program:
// This program provides simple GUI to control servo motors.
// The motors are proportionally controlled by using 3 scrollbars.

#include "TestForm_res.h"	// include form resource
// PPR.H
#define PILOT_PRECOMPILED_HEADERS_OFF
#include <Common.h>
#include <Pilot.h>
#include <SysAll.h>
#include <UIAll.h>
#include <SerialMgr.h>

UInt portRef;      // serial port reference set by serial library

Boolean Form1Handle(EventPtr event);	// prototype for event handler 
void Servo(int number, int speed);
void StopRobot(void);
void EventLoop();

// Send value to given servo
void Servo(int number, int speed) {
  Err error;
  char buf[10];	// buffer
  int len;			// buffer length
  StrPrintF(buf, "SV%d M%d \r", number, speed);	// store commands into buffer
  len = StrLen(buf);														// get length of buffer
  SerSendWait(portRef, -1); 										// wait for port to clear
  SerSend(portRef, buf, len, &error); 					// send buffer
}


// Stop robot
void StopRobot(void) {
	Servo(1,0);
	Servo(2,0);
	Servo(3,0);
	Servo(4,0);
	Servo(5,0);
	Servo(6,0);
}


// Main event loop
// The loop uses Form1Handle to handle all events
void EventLoop() {
  EventType e;
  unsigned short err, formID;
  FormType* form;
  do {
		EvtGetEvent(&e,-1);
    if (SysHandleEvent(&e)) continue;
    if (MenuHandleEvent(0, &e, &err)) continue;
    if (e.eType == frmLoadEvent) {
      formID = e.data.frmLoad.formID;
      form=FrmInitForm(formID);
      FrmSetActiveForm(form);
      switch (formID) {
        case Form1Form: FrmSetEventHandler(form, (FormEventHandlerPtr) Form1Handle); break; } }
    FrmDispatchEvent(&e);
  } while(e.eType != appStopEvent);
}

// Main function; required for all applications
DWord  PilotMain (Word cmd, Ptr cmdPBP, Word launchFlags) {
	if (cmd == sysAppLaunchCmdNormalLaunch) {	// application launched
	  SysLibFind("Serial Library", &portRef);	// find serial library
  	SerOpen(portRef, 0, 9600);							// open serial port at 9600BPS
	  FrmGotoForm(Form1Form);									// go to Form1 form
		EventLoop();														// run main event loop
		SerClose(portRef); }										// close serial port
	return 0;
}


// ***** Robot's functions *****
// Main event handler
Boolean Form1Handle(EventPtr event) {
	Boolean Handled=false;
    switch (event->eType) {
			case frmOpenEvent:
    		Handled=true;
        FrmDrawForm(FrmGetActiveForm());
				break;
      case nilEvent: 
       	Handled=true;
        break;
			case sclRepeatEvent:													// Scrollbar: pen drag
     		switch(event->data.ctlSelect.controlID) {	
					case Form1Servo1ScrollBar:								// scrollbar Servo1
						Servo(1, event->data.sclRepeat.value);	// set servo's speed to scrollbar's value
						break;
					case Form1Servo2ScrollBar:								// scrollbar Servo2
						Servo(2, event->data.sclRepeat.value); 	// set servo's speed to scrollbar's value
						break;
					case Form1Servo3ScrollBar:								// scrollbar Servo3
						Servo(3, event->data.sclRepeat.value);	// set servo #1's speed to scrollbar's value
						break;
					case Form1Servo4ScrollBar:								// scrollbar Servo3
						Servo(4, event->data.sclRepeat.value);	// set servo #1's speed to scrollbar's value
						break;	
					case Form1Servo5ScrollBar:								// scrollbar Servo3
						Servo(5, event->data.sclRepeat.value);	// set servo #1's speed to scrollbar's value
						break;	
					case Form1Servo6ScrollBar:								// scrollbar Servo3
						Servo(6, event->data.sclRepeat.value);	// set servo #1's speed to scrollbar's value
						break;	
						 }
				break;	
      case ctlSelectEvent:													// Button: click
        switch (event->data.ctlSelect.controlID) {
					case Form1StopButton:											// 'stop' button
						StopRobot();														// stop all servo motors 
						break; }
	      Handled=true;
        break;
	    default:
	    	FrmHandleEvent(FrmGetActiveForm(), event);
	    	Handled=true;
	    	break; }
  return Handled;
}

