// PPR.H
#define PILOT_PRECOMPILED_HEADERS_OFF
#include <Common.h>
#include <Pilot.h>
#include <SysAll.h>
#include <UIAll.h>
#include <SerialMgr.h>

UInt portRef;      // serial port reference set by serial library

Boolean Form1Handle(EventPtr event);	// prototype for event handler 
void Servo(int number, int speed);
void StopRobot(void);
void EventLoop();

// Send value to given servo
void Servo(int number, int speed) {
  Err error;
  char buf[10];	// buffer
  int len;			// buffer length
  StrPrintF(buf, "SV%d M%d \r", number, speed);	// store commands into buffer
  len = StrLen(buf);														// get length of buffer
  SerSendWait(portRef, -1); 										// wait for port to clear
  SerSend(portRef, buf, len, &error); 					// send buffer
}


// Stop robot
void StopRobot(void) {
	Servo(1,0);
	Servo(2,0);
	Servo(3,0);
}


// Main event loop
// The loop uses Form1Handle to handle all events
void EventLoop() {
  EventType e;
  unsigned short err, formID;
  FormType* form;
  do {
		EvtGetEvent(&e,-1);
    if (SysHandleEvent(&e)) continue;
    if (MenuHandleEvent(0, &e, &err)) continue;
    if (e.eType == frmLoadEvent) {
      formID = e.data.frmLoad.formID;
      form=FrmInitForm(formID);
      FrmSetActiveForm(form);
      switch (formID) {
        case Form1Form: FrmSetEventHandler(form, (FormEventHandlerPtr) Form1Handle); break; } }
    FrmDispatchEvent(&e);
  } while(e.eType != appStopEvent);
}

// Main function; required for all applications
DWord  PilotMain (Word cmd, Ptr cmdPBP, Word launchFlags) {
	if (cmd == sysAppLaunchCmdNormalLaunch) {	// application launched
	  SysLibFind("Serial Library", &portRef);	// find serial library
  	SerOpen(portRef, 0, 9600);							// open serial port at 9600BPS
	  FrmGotoForm(Form1Form);									// go to Form1 form
		EventLoop();														// run main event loop
		SerClose(portRef); }										// close serial port
	return 0;
}
