// PalmPilot Robot source code
// Part of Robot1 project
// Modified by Greg Reshko 1/19/2000.

#define PILOT_PRECOMPILED_HEADERS_OFF
#include <Common.h>
#include <Pilot.h>
#include <SysAll.h>
#include <UIAll.h>
#include <FeatureMgr.h>
#include <SerialMgr.h>

#include "Robot2.h"


#define Form1 1000
#define FwdButton 1001
#define StopButton 1002
#define IRScanButton 1003
#define IRValueField 1004
#define DriveWTButton 1005

#define Forward 3
#define Stop 5

static int StartApplication();
static void EventLoop();
static void StopApplication();
static Boolean Form1Handle(EventPtr event);


void Drive(int sv1, int sv2, int sv3);
void Servo(int number, int speed);
int SensorScan(int number);
void Tracker(void);

UInt portRef;      /* port reference, set by serial library, needed for communication with port */

DWord  PilotMain (Word cmd, Ptr cmdPBP, Word launchFlags)
{
  /* main function; required for all applications, nothing special here */
  short error;
  if (cmd == sysAppLaunchCmdNormalLaunch)
  {
    error = StartApplication();
    if (error) return error;
    EventLoop();
    StopApplication ();
  }
  return 0;
}

static int StartApplication() {
  /* initialize everything before processing events */
//  Err error;

  /* get the port reference and open the serial port */
  SysLibFind("Serial Library", &portRef);
  SerOpen(portRef, 0, 9600);

  /* and open the first (and in this case, only) form */
  FrmGotoForm(Form1);
  return 0;
}



// ************* ROBOT'S FUNCTIONS *************

// "Wall follow" algorithm
void Tracker(void) {
	int sensor, ok=1;
//	Drive(0,180,180); // drive forward
	while (ok == 1) {
		sensor = SensorScan(1);
		if (sensor > 72)	// too far -> turn right
			Drive(180,50,180);
		if (sensor < 68)	// too close -> turn left
			Drive(80,50,180);
		if ( (sensor < 72) && (sensor > 68) )	// continue straight
			Drive(0,50,180);
		if (sensor < 30)	// lift the robot to stop it
			ok = 0; }
	Drive(0,0,0);
}


// Reads and displays value of given analog sensor
int SensorScan(int number) {
	FormPtr frm = FrmGetActiveForm();
	// send request for analog value to SSC board
	Err error;
	int digit[3];
	char buf[10];
	char incoming[]="       ";
	int value=20;
	int len;
	int k=0,l;	// loop variable
	StrPrintF(buf, "AD%d \r", number);
	len = StrLen(buf);
	SerSendWait(portRef, -1); // wait for port to clear
	SerSend(portRef, buf, len, &error); // send buffer
//	SerReceiveWait(portRef, 3, 10); // wait for port to accumulate bytes
	// receive from portRef into incoming buffer using 5 bytes and 3ms timeout
	SerReceive(portRef, incoming, 4, 10, &error);
	
	// buffer correction -- replace all ASCII non-numbers with spaces
	for (l=0; l<=5; l++)
		if ( (incoming[l] < '0' ) || (incoming[l] > '9') )
			incoming[l]=' ';

    // update IRValue field
	FrmHideObject(frm, IRValueField);
	FrmCopyLabel(frm, IRValueField, incoming); // set field to incoming
	FrmShowObject(frm, IRValueField);
  
	SerReceiveFlush(portRef, 5); // flush buffers
	SerSendFlush(portRef);
	// since atoi() does not work for some reason:
	for (l=0; l<=3; l++) {
		switch (incoming[l]) {
			case '0': digit[k]=0; k++; break;
			case '1': digit[k]=1; k++; break;
			case '2': digit[k]=2; k++; break;
			case '3': digit[k]=3; k++; break;
			case '4': digit[k]=4; k++; break;
			case '5': digit[k]=5; k++; break;
			case '6': digit[k]=6; k++; break;
			case '7': digit[k]=7; k++; break;
			case '8': digit[k]=8; k++; break;
			case '9': digit[k]=9; k++; break;
			default: break; }}
	// k - number of digits
	if (k == 2)
		value = digit[0]*10 + digit[1]; 
	if (l == 3)
		value = digit[0]*100 + digit[1]*10 + digit[2]; 
	return value;
}

// Updates all 3 drive servos
void Drive(int sv1, int sv2, int sv3) {
  Servo(1, sv1);
  Servo(2, sv2);
  Servo(3, sv3);
}


// Sends value to given servo
void Servo(int number, int speed) {
  Err error;
  char buf[10];
  int len;
  StrPrintF(buf, "SV%d M%d \r", number, speed);
  len = StrLen(buf);
  SerSendWait(portRef, -1); // wait for port to clear
  SerSend(portRef, buf, len, &error); // send buffer
}

// ************* END OF ROBOT'S FUNCTIONS *************

static void EventLoop() {
  /* main event loop, pretty standard for Palm application */
  EventType e;
  unsigned short err, formID;
  FormType* form;
  do {
    EvtGetEvent(&e,-1);
    if (SysHandleEvent(&e)) continue;
    if (MenuHandleEvent((void *)0, &e, &err)) continue;
    if (e.eType == frmLoadEvent) {
      formID = e.data.frmLoad.formID;
      form=FrmInitForm(formID);
      FrmSetActiveForm(form);
      switch (formID) {
        case Form1: FrmSetEventHandler(form, (FormEventHandlerPtr) Form1Handle); break;
      }
    }
    FrmDispatchEvent(&e);
  } while(e.eType != appStopEvent);
}

static void StopApplication () {
  /* clean up after the application before exiting */
  /* stop the servos, */
  /* wait for the stop message to complete, */
  //SerSendWait(portRef, -1);
  /* and close the serial port */
  SerClose(portRef);
}

static Boolean Form1Handle(EventPtr event) {
	Boolean Handled=false;
    switch (event->eType) {
    	case frmOpenEvent:
    		Handled=true;
        	FrmDrawForm(FrmGetActiveForm());
			break;
        case nilEvent: 
        	Handled=true;
            break;
	    case penDownEvent:   break;
        case penUpEvent:     break;
        case penMoveEvent:   break;
        case keyDownEvent:   break;
        case winEnterEvent:  break;
        case winExitEvent:   break;
        case frmGotoEvent:   break;
        case frmUpdateEvent: break;
        case frmSaveEvent:   break;
        case frmCloseEvent:  break;
        case ctlEnterEvent:
        	switch (event->data.ctlEnter.controlID) {
				case Form1FwdButton:     break;
				case Form1StopButton:    break;
				case Form1IRScanButton:  break;
				case Form1DriveWTButton: break; }
            break;
        case ctlExitEvent:
            switch (event->data.ctlEnter.controlID) {
				case Form1FwdButton:  break;
				case Form1StopButton: break;
				case Form1IRScanButton:  break;
				case Form1DriveWTButton: break; }
            break; 
        case ctlSelectEvent:
            switch (event->data.ctlSelect.controlID) {
            	// Click: Forward Button
				case Form1FwdButton:
				    Drive(200, 200, 200);
					break;
				// Click: Stop Button
				case Form1StopButton:
					Drive(0,0,0);
					break;
				// Click: IRScan Button
				case Form1IRScanButton:
					SensorScan(1);
					break;
				// Click: DriveWT Button
				case Form1DriveWTButton:
					Tracker();
					break; }
	        Handled=true;
            break;
/*        case popSelectEvent:
        	switch (event->data.popSelect.controlID) {}
            Handled=true;
            break;
        case ctlRepeatEvent:
            switch (event->data.ctlRepeat.controlID) {}
            Handled=true;
            break;
        case fldEnterEvent:
            switch (event->data.fldEnter.fieldID) {}
            break;
        case fldHeightChangedEvent:
            switch (event->data.fldHeightChanged.fieldID) {}
            Handled=true;
            break;
        case fldChangedEvent:
            switch (event->data.fldChanged.fieldID) {}
            Handled=true;
            break;
        case menuEvent:
            switch (event->data.menu.itemID) {}
            Handled=true;
            break; */
	    default:
	    	FrmHandleEvent(FrmGetActiveForm(), event);
	    	Handled=true;
	    	break;
  }
  return Handled;
}












