// PalmPilot Robot source code
// Part of Robot1 project
// Modified by Greg Reshko 1/19/2000.

#define PILOT_PRECOMPILED_HEADERS_OFF
#include <Common.h>
#include <Pilot.h>
#include <SysAll.h>
#include <UIAll.h>
#include <FeatureMgr.h>
#include <SerialMgr.h>

#define Form1 1
#define FwdButton 2
#define StopButton 3

#define Forward 3
#define Stop 5

static int StartApplication();
static void EventLoop();
static void StopApplication();
static Boolean Form1Handle(EventPtr event);
static Err MySerSend(int sv1, int sv2);

UInt portRef;      /* port reference, set by serial library, needed for communication with port */

DWord  PilotMain (Word cmd, Ptr cmdPBP, Word launchFlags)
{
  /* main function; required for all applications, nothing special here */
  short error;
  if (cmd == sysAppLaunchCmdNormalLaunch)
  {
    error = StartApplication();
    if (error) return error;
    EventLoop();
    StopApplication ();
  }
  return 0;
}

static int StartApplication() {
  /* initialize everything before processing events */
  Err error;

  /* get the port reference and open the serial port */
  SysLibFind("Serial Library", &portRef);
  SerOpen(portRef, 0, 9600);

  /* and open the first (and in this case, only) form */
  FrmGotoForm(Form1);
  return 0;
}


static Err MySerSend(int sv1, int sv2) {
  /* send values 'sv1' and 'sv2' to servos 1 and 2 respectively */
  Err error;
  char buf[20];
  int len;

  StrPrintF(buf, "SV1 M%d SV2 M%d", sv1, sv2);
  /* put the carriage return code '13' into buf */
  len = StrLen(buf);
  buf[len] = 13;
  len++;
  buf[len] = '\0';
  /* wait for other serial port activity to complete */
  SerSendWait(portRef, -1);
  /* and send the string */
  SerSend(portRef, buf, len, &error);
  return error;
}

static void EventLoop() {
  /* main event loop, pretty standard for Palm application */
  EventType e;
  unsigned short err, formID;
  FormType* form;
  do {
    EvtGetEvent(&e,-1);
    if (SysHandleEvent(&e)) continue;
    if (MenuHandleEvent((void *)0, &e, &err)) continue;
    if (e.eType == frmLoadEvent) {
      formID = e.data.frmLoad.formID;
      form=FrmInitForm(formID);
      FrmSetActiveForm(form);
      switch (formID) {
        case Form1: FrmSetEventHandler(form, (FormEventHandlerPtr) Form1Handle); break;
      }
    }
    FrmDispatchEvent(&e);
  } while(e.eType != appStopEvent);
}

static void StopApplication () {
  /* clean up after the application before exiting */
  /* stop the servos, */
  MySendStop();
  /* wait for the stop message to complete, */
  SerSendWait(portRef, -1);
  /* and close the serial port */
  SerClose(portRef);
}

static Boolean Form1Handle(EventPtr event) {
	Boolean Handled=false;
    switch (event->eType) {
    	case frmOpenEvent:
    		Handled=true;
        	FrmDrawForm(FrmGetActiveForm());
			break;
        case nilEvent: 
        	Handled=true;
            break;
	    case penDownEvent: 
            break;
        case penUpEvent: 
            break;
        case penMoveEvent: 
            break;
        case keyDownEvent: 
               break;
          case winEnterEvent: 

               break;
          case winExitEvent: 

               break;
          case frmGotoEvent: 

               break;
          case frmUpdateEvent: 

               break;
          case frmSaveEvent: 

               break;
          case frmCloseEvent: 

               break;
        case ctlEnterEvent:
        	switch (event->data.ctlEnter.controlID) {
				case FwdButton:
					break;
				case StopButton:
					break; }
            break;
        case ctlExitEvent:
            switch (event->data.ctlEnter.controlID) {
				case FwdButton:
	               break;
				case StopButton:
	               break; }
            break;
        case ctlSelectEvent:
            switch (event->data.ctlSelect.controlID) {
				case FwdButton:
				    MySerSend(200, 200);
					break;
				case StopButton:
					MySerSend(0,0);
					break; }
	        Handled=true;
            break;
        case popSelectEvent:
        	switch (event->data.popSelect.controlID) {}
            Handled=true;
            break;
        case ctlRepeatEvent:
            switch (event->data.ctlRepeat.controlID) {}
            Handled=true;
            break;
        case fldEnterEvent:
            switch (event->data.fldEnter.fieldID) {}
            break;
        case fldHeightChangedEvent:
            switch (event->data.fldHeightChanged.fieldID) {}
            Handled=true;
            break;
        case fldChangedEvent:
            switch (event->data.fldChanged.fieldID) {}
            Handled=true;
            break;
        case menuEvent:
            switch (event->data.menu.itemID) {}
            Handled=true;
            break;
	    default:
	    	FrmHandleEvent(FrmGetActiveForm(), event);
	    	Handled=true;
	    	break;
  }
  return Handled;
}












