// *************************************************************
// The Robotics Institute
// Carnegie Mellon University
// Copyright (C) 2000 by RI.
// All Rights Reserved.
//
// File: 					sv203.h
// Project: 			PalmPilot Robot source code (Advanced project)
// Author: 				Greg Reshko
// Last modified: 4/03/2000
// Program:
// SV203 class
// The class provides functions, variables, etc. necessary for
// communication between Palm Pilot and SV203 servo-motor 
// controller.
// *************************************************************

#ifndef __SV203_H__
#define __SV203_H__


class SV203 {
private:
	UInt portRef;      			// serial port reference set by serial library
public:
	SV203();																// initialize board
	~SV203();																// close COM port
	void Tx(char *command, int parameter);	// transmit string to board
	void Rc(char *buffer);									// receive string from board
};

#include "sv203.cpp"			// implementation of SV203 class

#endif __SV203_H__