// *************************************************************
// The Robotics Institute
// Carnegie Mellon University
// Copyright (C) 2000 by RI.
// All Rights Reserved.
//
// File: 					robot.h
// Project: 			PenFollow
// Author: 				Greg Reshko
// Last modified: 11/23/2000
// Program:
// Robot class
// The class provides functions, variables, etc. necessary for
// control of the PalmPilot Robot's motors and sensors.
// The class includes functions to display messages.
// *************************************************************

#ifndef __ROBOT_H__
#define __ROBOT_H__


class Robot {
private:
	double x, y, theta;															// current (x,y,theta) coordinates
	int ir[3];																			// current values of IR sensors
	SV203 board;																		// robot's board
	int Vel_To_Value(double vel);										// converts velocity to servo value
	int Sensor_To_Range(double ir_value);						// converts ir value to distance in cm	
public:
	Robot();																				// constructor
	~Robot();																				// destructor
	void Servo(int servo_number, int velocity);			// drive 1 servo-motor
	void Drive(int s1_vel, int s2_vel, int s3_vel);	// drive 3 servo-motors
	void Vector_Drive(vector dir, double omega);		// drive the whole robot
	void Stop(void);																// stop robot
	int  IRDist(int ir_number);											// get distance from IR sensor

	void Wait(int delay_ticks, int *interrupt); 		// interruptable wait
	void Wait(int delay_ticks);											// non-interruptable wait
	void Disp(char *str, int x, int y);	// displays string at given point
	void Disp(int i, int x, int y);			// displays int at given point
	
	void Disp(int i) { Disp(i, 10, 140); }
	void Disp(char *str) { Disp(str, 10, 140); }

};

#include "robot.cpp"			// implementation of Robot class

#endif __ROBOT_H__