/* MathLib: Pilot shared library of IEEE-754 double math functions
 *
 * Private declarations for use only within MathLib source code.
 *
 * Copyright (C) 1997 Rick Huebner
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; see file COPYING.LIB.  If not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA
 *
 * Version 1.01, 23 August 1997, Rick Huebner
 */
#ifndef __MATHLIBPRV_H__
#define __MATHLIBPRV_H__

// Our global data structure
typedef struct MathLibData {
	UInt usecount;
} MathLibData;

// Control function prototypes
Err __Startup__(UInt refnum, SysLibTblEntryPtr entryP);
Ptr *DispatchTable(void);

Err mathlib_open(UInt refnum, UInt version);
Err mathlib_close(UInt refnum, UIntPtr numappsP);
Err mathlib_sleep(UInt refnum);
Err mathlib_wake(UInt refnum);

// Dispatch table jmp target/GCC encapsulation prototypes
Err mathlib_acos(UInt refnum, double x, double *result);
Err mathlib_asin(UInt refnum, double x, double *result);
Err mathlib_atan(UInt refnum, double x, double *result);
Err mathlib_atan2(UInt refnum, double y, double x, double *result);
Err mathlib_cos(UInt refnum, double x, double *result);
Err mathlib_sin(UInt refnum, double x, double *result);
Err mathlib_tan(UInt refnum, double x, double *result);
Err mathlib_sincos(UInt refnum, double x, double *sinx, double *cosx);
Err mathlib_cosh(UInt refnum, double x, double *result);
Err mathlib_sinh(UInt refnum, double x, double *result);
Err mathlib_tanh(UInt refnum, double x, double *result);
Err mathlib_acosh(UInt refnum, double x, double *result);
Err mathlib_asinh(UInt refnum, double x, double *result);
Err mathlib_atanh(UInt refnum, double x, double *result);
Err mathlib_exp(UInt refnum, double x, double *result);
Err mathlib_frexp(UInt refnum, double x, double *fraction, Int *exponent);
Err mathlib_ldexp(UInt refnum, double x, Int exponent, double *result);
Err mathlib_log(UInt refnum, double x, double *result);
Err mathlib_log10(UInt refnum, double x, double *result);
Err mathlib_modf(UInt refnum, double x, double *intpart, double *fracpart);
Err mathlib_expm1(UInt refnum, double x, double *result);
Err mathlib_log1p(UInt refnum, double x, double *result);
Err mathlib_logb(UInt refnum, double x, double *result);
Err mathlib_log2(UInt refnum, double x, double *result);
Err mathlib_pow(UInt refnum, double x, double y, double *result);
Err mathlib_sqrt(UInt refnum, double x, double *result);
Err mathlib_hypot(UInt refnum, double x, double y, double *result);
Err mathlib_cbrt(UInt refnum, double x, double *result);
Err mathlib_ceil(UInt refnum, double x, double *result);
Err mathlib_fabs(UInt refnum, double x, double *result);
Err mathlib_floor(UInt refnum, double x, double *result);
Err mathlib_fmod(UInt refnum, double x, double y, double *result);
Err mathlib_isinf(UInt refnum, double x, Int *result);
Err mathlib_finite(UInt refnum, double x, Int *result);
Err mathlib_scalbn(UInt refnum, double x, Int exponent, double *result);
Err mathlib_drem(UInt refnum, double x, double y, double *result);
Err mathlib_significand(UInt refnum, double x, double *result);
Err mathlib_copysign(UInt refnum, double x, double y, double *result);
Err mathlib_isnan(UInt refnum, double x, Int *result);
Err mathlib_ilogb(UInt refnum, double x, Int *result);
Err mathlib_rint(UInt refnum, double x, double *result);
Err mathlib_nextafter(UInt refnum, double x, double y, double *result);
Err mathlib_remainder(UInt refnum, double x, double y, double *result);
Err mathlib_scalb(UInt refnum, double x, double exponent, double *result);
Err mathlib_round(UInt refnum, double x, double *result);
Err mathlib_trunc(UInt refnum, double x, double *result);
Err mathlib_signbit(UInt refnum, double x, ULong *result);

#endif // __MATHLIBPRV_H__
