// *************************************************************
// The Robotics Institute
// Carnegie Mellon University
// Copyright (C) 2000 by RI.
// All Rights Reserved.
//
// File: 					Main.cpp
// Project: 			PenFollow
// Author: 				Greg Reshko
// Last modified: 11/29/2000
// Program:
// Pen follow program.
// *************************************************************


#include "penfollowform.h"	// include form resource
#define PILOT_PRECOMPILED_HEADERS_OFF
#include <Common.h>
#include <Pilot.h>
#include <SysAll.h>
#include <UIAll.h>
#include <SerialMgr.h>

#include "MathLib.h"	// Pilot IEEE-754 double math functions
						// Note: Library requires installed MathLib.prc 
#include "vecmath.h"	// vector math operations
#include "sv203.h"		// SV203 board class
#include "robot.h"		// Robot class


Robot myrobot;	// create "myrobot" PalmPilot Robot

Boolean MainHandle(EventPtr event);	// prototype for event handler 

// Simple demo/test function
void SimpleFunction(void) {
	EventPtr e;
	int q=0, k=1000;
	int pv = -1;	// robot version -1 for Acroname's, +1 for mine
	double x=100, y=100, xx, yy;
	vector A(0.00,0.00);
	myrobot.Disp("Running...", 0, 10);
	while (q == 0)
	{
		EvtGetEvent(e, 1);
		if (e->eType == penMoveEvent)
		{
			WinEraseLine(80, 80, x, y);
			x = e->screenX;
			y = e->screenY;
			WinDrawLine(80, 80, x, y);
			xx = pv*(x-80)/k;	
			yy = pv*(y-80)/k;
			A.Set(xx,yy);
			myrobot.Disp(int(xx*k), 10, 140);
			myrobot.Disp(int(yy*k), 40, 140);
			if (int(pv*xx*k) > 0 && int(pv*yy*k) > 60)	// move pen toward stop button to stop
				q = 1;			
			else
				myrobot.Vector_Drive(A, 0);				// drive in direction of A vector
		}
	}

	myrobot.Disp("Stopped...", 0, 10);
	myrobot.Stop();											// stop
}


// Main event loop
// The loop uses Form1Handle to handle all events
void EventLoop() {
  EventType e;
  unsigned short err, formID;
  FormType* form;
  do {
		EvtGetEvent(&e,-1);
    if (SysHandleEvent(&e)) continue;
    if (MenuHandleEvent(0, &e, &err)) continue;
    if (e.eType == frmLoadEvent) {
      formID = e.data.frmLoad.formID;
      form=FrmInitForm(formID);
      FrmSetActiveForm(form);
      switch (formID) {
        case MainForm: FrmSetEventHandler(form, (FormEventHandlerPtr) MainHandle); break; } }
    FrmDispatchEvent(&e);
  } while(e.eType != appStopEvent);
}

// Main function; required for all applications
DWord  PilotMain (Word cmd, Ptr cmdPBP, Word launchFlags) {
	if (cmd == sysAppLaunchCmdNormalLaunch) {	// application launched
	  FrmGotoForm(MainForm);									// go to Main form
		EventLoop(); }													// run main event loop 
	return 0;
}


// Main event handler
Boolean MainHandle(EventPtr event) {
	Boolean Handled=false;
    switch (event->eType) {
			case frmOpenEvent:
    		Handled=true;
        FrmDrawForm(FrmGetActiveForm());
				break;
      case nilEvent: 
       	Handled=true;
        break;
			case ctlSelectEvent:													// Button: click
        switch (event->data.ctlSelect.controlID) {
					case MainStartButton:											// 'Stop' button
						SimpleFunction();
						break; }
	      Handled=true;
        break;
	    default:
	    	FrmHandleEvent(FrmGetActiveForm(), event);
	    	Handled=true;
	    	break; }
  return Handled;
}

