/* -*- Mode: C++ -*- */

/* Misc utility types, classes, and functions */

#ifndef _SOCCER_UTILS_H_
#define _SOCCER_UTILS_H_

#include <iostream>
#include <vector>
#include "region.h"

typedef int Time;

typedef int Unum;
const Unum Unum_Unknown = 0;

enum TeamSide {
  TS_None,
  TS_Left,
  TS_Right,
  TS_Both
};

enum RelativeTeamSide {
  RTS_None,
  RTS_Mine,
  RTS_Theirs
};

std::ostream & operator << (std::ostream & o, const TeamSide& ts);
std::istream & operator >> (std::istream & i, TeamSide& ts);
std::ostream & operator << (std::ostream & o, const RelativeTeamSide& rts);
std::istream & operator >> (std::istream & i, RelativeTeamSide& ts);

TeamSide relativeTeamSideToAbs( RelativeTeamSide rts, TeamSide myside);
RelativeTeamSide absTeamSideToRelative( TeamSide ts, TeamSide myside);

inline TeamSide invertSide(TeamSide s) { return relativeTeamSideToAbs(RTS_Theirs, s); }

  
enum PlayerRole {
  PR_None,
  PR_Goaltender,
  PR_Sweeper,
  PR_Defender,
  PR_Midfielder,
  PR_Forward
};

bool inferRolesFromRegion(const std::vector<rcss::clang::Region*>& vReg,
			  std::vector<PlayerRole>& vRole,
			  int goalie_num);

VecPosition getGoalPosForSide(TeamSide ts);

TeamSide getOppositeSide(TeamSide ts);


// determines which side the side_str and team_str are talking about
// side_str is checked first, if it is 'left' or 'right', we are done
// otherwise, it should be empty or 'none'
// otherwise, the team_str is compared.
// The team names are allowed to not be filled in
// If a match is found, TS_Left or TS_RIght is returned
// If no match can be found, TS_None is returned
// If no match because of empty team names, TS_Both is returned
TeamSide determineSide(const char* side_str, const char* team_str,
		       const char* left_team_name, const char* right_team_name);


//the _sh is for shared
float VelAtPt2VelAtFoot_sh(VecPosition pt, float targ_vel_at_pt, 
			   VecPosition mypos, float ball_decay);

int CyclesForBallToPoint(VecPosition pt, float targ_vel_at_pt, float max_kick_speed, 
			 VecPosition mypos, float ball_decay);

int UpperBForPlayerToPoint(VecPosition start, VecPosition end);


int kick_time_helper(VecPosition start, VecPosition end, float targ_vel_at_pt,
		     float max_kick_speed, int cycles_to_kick);
int UpperBForKickToPoint(VecPosition start, VecPosition end, float targ_vel_at_pt);
int AvgTimeForKickToPoint(VecPosition start, VecPosition end, float targ_vel_at_pt);
int MinTimeForKickToPoint(VecPosition start, VecPosition end, float targ_vel_at_pt);


//cycles left in game
int CyclesRemaining(int curr_cycle);
//cycles left in current half
int CyclesRemainingHalf(int curr_cycle);


#endif

