#!/usr/local/bin/perl5 -w

# This script does a simple search and replace on a file to generate stuff with
# given search and replace string in another file

$usage = "$0 <repl input file> <input file> <output file>";

$cmdline = join ' ', @ARGV;

$replfn = shift @ARGV;
$infn = shift @ARGV;
$outfn = shift @ARGV;
die $usage if (!defined($infn) or !defined($outfn));


#First, read the replacements to do
open(REPL, "<$replfn") || die "Could not open replacements file '$replfn': $!";
while (<REPL>)
  {
    chomp;
    s/\#.*//;
    next if (/^\s*$/);
    ($srch, $repl) = split '\s*:\s*';
    $repl =~ s/^\s+//;
    $repl{$srch} = $repl;
  }
close (REPL);

# Now, process the input file to the output file
open(INFH, "<$infn") || die "Could not open in file '$infn': $!";
open(OUTFH, ">$outfn") || die "Could not open out file '$outfn': $!";

print OUTFH <<EOH;
# DO NOT EDIT
# THis is an automatically generated file create by $0 with this command line
# $cmdline
EOH

while (<INFH>)
  {
    foreach $srch (keys %repl)
      {
	$repl = $repl{$srch};
	s/$srch/$repl/g;
      }
    print OUTFH;
  }
close (INFH);
close (OUTFH);
