/* these are types for setplay planning */

#ifndef _SETPLAY_TYPES_H_
#define _SETPLAY_TYPES_H_

#include "cond.h"

//These must start and 0 and be continuous
const int num_SetPlayMode = 13;
enum SetPlayMode{
 SPM_No_Mode,
 SPM_My_Kick_Off,
 SPM_Their_Kick_Off,
 SPM_My_Kick_In,
 SPM_Their_Kick_In,
 SPM_My_Corner_Kick,
 SPM_Their_Corner_Kick,
 SPM_My_Goal_Kick,
 SPM_Their_Goal_Kick,
 SPM_My_Free_Kick,
 SPM_Their_Free_Kick,
 SPM_My_Goalie_Catch,
 SPM_Their_Goalie_Catch
};

#define SETPLAYMODE_STRINGS {\
"NoMode",\
"MyKickOff",\
"TheirKickOff",\
"MyKickIn",\
"TheirKickIn",\
"MyCornerKick",\
"TheirCornerKick",\
"MyGoalKick",\
"TheirGoalKick",\
"MyFreeKick",\
"TheirFreeKick",\
"MyGoalieCatch",\
"TheirGoalieCatch" }

//These must start and 0 and be continuous
//These are slightly more specialized modes from the ones above
//Right now, the coach uses these to get good seeds for hillclimbing
const int num_SpecSetPlayMode = 21;
enum SpecSetPlayMode{
 SSPM_No_Mode,
 SSPM_My_Kick_Off,
 SSPM_Their_Kick_Off,
 SSPM_My_Kick_In_Def, //defensive for us
 SSPM_My_Kick_In_Mid,
 SSPM_My_Kick_In_Off,
 SSPM_Their_Kick_In_Def, //defensive for them
 SSPM_Their_Kick_In_Mid,
 SSPM_Their_Kick_In_Off,
 SSPM_My_Corner_Kick,
 SSPM_Their_Corner_Kick,
 SSPM_My_Goal_Kick,
 SSPM_Their_Goal_Kick,
 //we assume free kicks are defensive since the only we really get them are offsides
 SSPM_My_Free_Kick_Upper,
 SSPM_My_Free_Kick_Mid,
 SSPM_My_Free_Kick_Lower,
 SSPM_Their_Free_Kick_Upper,
 SSPM_Their_Free_Kick_Mid,
 SSPM_Their_Free_Kick_Lower,
 SSPM_My_Goalie_Catch,
 SSPM_Their_Goalie_Catch
};

#define SPECSETPLAYMODE_STRINGS {\
 "NoMode",\
 "MyKickOff",\
 "TheirKickOff",\
 "MyKickInDef",\
 "MyKickInMid",\
 "MyKickInOff",\
 "TheirKickInDef",\
 "TheirKickInMid",\
 "TheirKickInOff",\
 "MyCornerKick",\
 "TheirCornerKick",\
 "MyGoalKick",\
 "TheirGoalKick",\
 "MyFreeKickUpper",\
 "MyFreeKickMid",\
 "MyFreeKickLower",\
 "TheirFreeKickUpper",\
 "TheirFreeKickMid",\
 "TheirFreeKickLower",\
 "MyGoalieCatch",\
 "TheirGoalieCatch" }


SetPlayMode GetSetPlayMode(char* str);
const char* GetSetPlayModeString(SetPlayMode spm);
bool IsSetPlayDefensive(SetPlayMode spm);
bool IsSetPlayOffensive(SetPlayMode spm);

SpecSetPlayMode GetSpecSetPlayMode(char* str);
const char* GetSpecSetPlayModeString(SpecSetPlayMode spm);
SetPlayMode GetSPMForSpecSPM(SpecSetPlayMode spm);


rcss::clang::Cond* GetCMCondForSetPlayMode(SetPlayMode spm, int timet);



#endif
