
#include <string.h>
#include "setplay_types.h"
#include "Logger.h"
using namespace spades;

char* SetPlayMode_strings[num_SetPlayMode] = SETPLAYMODE_STRINGS;

SetPlayMode GetSetPlayMode(char* str)
{
  for (int i=0; i<num_SetPlayMode; i++) {
    if (strncmp(str, SetPlayMode_strings[i], strlen(SetPlayMode_strings[i])) == 0)
      return (SetPlayMode)i;
  }
  return SPM_No_Mode;
}

const char* GetSetPlayModeString(SetPlayMode spm)
{
  return SetPlayMode_strings[spm];
}

bool IsSetPlayDefensive(SetPlayMode spm)
{
  if (spm == SPM_Their_Kick_Off ||
      spm == SPM_Their_Kick_In ||
      spm == SPM_Their_Corner_Kick ||
      spm == SPM_Their_Goal_Kick ||
      spm == SPM_Their_Free_Kick ||
      spm == SPM_Their_Goalie_Catch)
    return true;
  return false;
}

bool IsSetPlayOffensive(SetPlayMode spm)
{
  if (spm == SPM_My_Kick_Off ||
      spm == SPM_My_Kick_In ||
      spm == SPM_My_Corner_Kick ||
      spm == SPM_My_Goal_Kick ||
      spm == SPM_My_Free_Kick ||
      spm == SPM_My_Goalie_Catch)
    return true;
  return false;
}

char* SpecSetPlayMode_strings[num_SpecSetPlayMode] = SPECSETPLAYMODE_STRINGS;

SpecSetPlayMode GetSpecSetPlayMode(char* str)
{
  for (int i=0; i<num_SpecSetPlayMode; i++) {
    if (strncmp(str, SpecSetPlayMode_strings[i], strlen(SpecSetPlayMode_strings[i])) == 0)
      return (SpecSetPlayMode)i;
  }
  return SSPM_No_Mode;
}

const char* GetSpecSetPlayModeString(SpecSetPlayMode spm)
{
  return SpecSetPlayMode_strings[spm];
}
SetPlayMode GetSPMForSpecSPM(SpecSetPlayMode spm)
{
  switch (spm) {
  case SSPM_No_Mode:
    return SPM_No_Mode;
  case SSPM_My_Kick_Off:
    return SPM_My_Kick_Off;
  case SSPM_Their_Kick_Off:
    return SPM_Their_Kick_Off;
  case SSPM_My_Kick_In_Def: 
  case SSPM_My_Kick_In_Mid:
  case SSPM_My_Kick_In_Off:
    return SPM_My_Kick_In;
  case SSPM_Their_Kick_In_Def:
  case SSPM_Their_Kick_In_Mid:
  case SSPM_Their_Kick_In_Off:
    return SPM_Their_Kick_In;
  case SSPM_My_Corner_Kick:
    return SPM_My_Corner_Kick;
  case SSPM_Their_Corner_Kick:
    return SPM_Their_Corner_Kick;
  case SSPM_My_Goal_Kick:
    return SPM_My_Goal_Kick;
  case SSPM_Their_Goal_Kick:
    return SPM_Their_Goal_Kick;
  case SSPM_My_Free_Kick_Upper:
  case SSPM_My_Free_Kick_Mid:
  case SSPM_My_Free_Kick_Lower:
    return SPM_My_Free_Kick;
  case SSPM_Their_Free_Kick_Upper:
  case SSPM_Their_Free_Kick_Mid:
  case SSPM_Their_Free_Kick_Lower:
    return SPM_Their_Free_Kick;
  case SSPM_My_Goalie_Catch:
    return SPM_My_Goalie_Catch;
  case SSPM_Their_Goalie_Catch:
    return SPM_Their_Goalie_Catch;
  default:
    errorlog << "What is SSPM: " << spm << ende;
    break;
  }
  return SPM_No_Mode;
}


/***************************************************************************/

rcss::clang::Cond*
GetCMCondForSetPlayMode(SetPlayMode spm, int timet)
{
  switch (spm) {
  case SPM_No_Mode:            return NULL;
  case SPM_My_Kick_Off: {
    rcss::clang::CondOr* pCond = new rcss::clang::CondOr;
    pCond->push_back(std::auto_ptr<rcss::clang::Cond>(new rcss::clang::CondPlayMode(rcss::clang::BeforeKickOff)));
    pCond->push_back(std::auto_ptr<rcss::clang::Cond>(new rcss::clang::CondPlayMode(rcss::clang::KickOff_Our)));
    pCond->push_back(std::auto_ptr<rcss::clang::Cond>(new rcss::clang::CondPlayMode(rcss::clang::AfterGoal_Opp)));      
    return pCond;
  } break;
  case SPM_Their_Kick_Off: {
    rcss::clang::CondOr* pCond = new rcss::clang::CondOr();
    pCond->push_back(std::auto_ptr<rcss::clang::Cond>(new rcss::clang::CondPlayMode(rcss::clang::BeforeKickOff)));
    pCond->push_back(std::auto_ptr<rcss::clang::Cond>(new rcss::clang::CondPlayMode(rcss::clang::KickOff_Opp)));
    pCond->push_back(std::auto_ptr<rcss::clang::Cond>(new rcss::clang::CondPlayMode(rcss::clang::AfterGoal_Our)));
    return pCond;
  } break;
  case SPM_My_Kick_In:         return new rcss::clang::CondPlayMode(rcss::clang::KickIn_Our);
  case SPM_Their_Kick_In:      return new rcss::clang::CondPlayMode(rcss::clang::KickIn_Opp);
  case SPM_My_Corner_Kick:     return new rcss::clang::CondPlayMode(rcss::clang::CornerKick_Our);
  case SPM_Their_Corner_Kick:  return new rcss::clang::CondPlayMode(rcss::clang::CornerKick_Opp);
  case SPM_My_Goal_Kick:       return new rcss::clang::CondPlayMode(rcss::clang::GoalKick_Our);
  case SPM_Their_Goal_Kick:    return new rcss::clang::CondPlayMode(rcss::clang::GoalKick_Opp);
  case SPM_My_Free_Kick:       return new rcss::clang::CondPlayMode(rcss::clang::FreeKick_Our);
  case SPM_Their_Free_Kick:    return new rcss::clang::CondPlayMode(rcss::clang::FreeKick_Opp);
  case SPM_My_Goalie_Catch:    return new rcss::clang::CondPlayMode(rcss::clang::GoalieCatch_Our);
  case SPM_Their_Goalie_Catch: return new rcss::clang::CondPlayMode(rcss::clang::GoalieCatch_Opp);
  default:
    errorlog << "GetCMCondForSetPlayMode: what is mode? " << spm << ende;
  }

  return NULL;
}


