/* -*- Mode: C++ -*- */

/* Misc utility funcs for the planning stuff */

#ifndef _PLAN_UTILS_H_
#define _PLAN_UTILS_H_

#include "planning/PlayerDistribution.h"

float GetOffsidesLine(TeamSide my_side, PlayerDistribution* pDist, float ballx);
inline float GetOffsidesLine(TeamSide my_side, PlayerDistribution* pDist, VecPosition ball_pos)
{ return GetOffsidesLine(my_side, pDist, ball_pos.getX()); }

float GetOffsidesLine(TeamSide my_side, float player_line, float ballx);
inline float GetOffsidesLine(TeamSide my_side, float player_line, VecPosition ball_pos)
{ return GetOffsidesLine(my_side, player_line, ball_pos.getX()); }


bool IsOffsidesPosition(TeamSide my_side, VecPosition pt, float offsides_line, float ballx = 0.0);
inline bool IsOffsidesPosition(TeamSide my_side, VecPosition pt, float offsides_line, VecPosition ball_pos)
{ return IsOffsidesPosition(my_side, pt, offsides_line, ball_pos.getX()); }
inline bool IsOffsidesPosition(TeamSide my_side, VecPosition pt, PlayerDistribution* pDist, 
			       float ballx = 0.0)
{ return IsOffsidesPosition(my_side, pt, pDist->getOffsidesLine(my_side == TS_Left), 
			    ballx); 
}
inline bool IsOffsidesPosition(TeamSide my_side, VecPosition pt, PlayerDistribution* pDist, VecPosition ball_pos)
{ return IsOffsidesPosition(my_side, pt, pDist, ball_pos.getX()); }

float XToOnsideX(TeamSide my_side, float x, float offsides_line);
inline VecPosition PtToOnsidePt(TeamSide my_side, VecPosition pt, float offsides_line)
{ return VecPosition( XToOnsideX(my_side, pt.getX(), offsides_line), pt.getY()); }

float XToOnHalfX(TeamSide my_side, float x, float buffer = 0.0);
inline VecPosition PtToOnHalfPt(TeamSide my_side, VecPosition pt, float buffer = 0.0)
{ return VecPosition( XToOnHalfX(my_side, pt.getX(), buffer), pt.getY()); }


bool IsPassTooFarOffsides(TeamSide my_side, VecPosition start, VecPosition end, float offsides_line);


#endif
