#include "plan_utils.h"
#include "ServerParam.h"
#include "CoachParam.h"
#include "Logger.h"
using namespace spades;

/*************************************************************************/

float GetOffsidesLine(TeamSide my_side, PlayerDistribution* pDist, float ballx)
{
  if (my_side == TS_Left) {
    actionlog(250) << "GetOffsidesLine(l): pDist: " << pDist->getOffsidesLine(true)
		   << ", ballx: " << ballx << ende;
    return Max(pDist->getOffsidesLine(true), ballx);
  } else {
    actionlog(250) << "GetOffsidesLine(r): pDist: " << pDist->getOffsidesLine(false)
		   << ", ballx: " << ballx << ende;    
    return Min(pDist->getOffsidesLine(false), ballx);
  }
  
}

float GetOffsidesLine(TeamSide my_side, float player_line, float ballx)
{
  if (my_side == TS_Left) {
    actionlog(250) << "GetOffsidesLine(l): pline: " << player_line
		   << ", ballx: " << ballx << ende;
    return Max(player_line, ballx);
  } else {
    actionlog(250) << "GetOffsidesLine(r): pline: " << player_line
		   << ", ballx: " << ballx << ende;    
    return Min(player_line, ballx);
  }
  
}



bool IsOffsidesPosition(TeamSide my_side, VecPosition pt, float offsides_line, float ballx)
{
  if (my_side == TS_Left) {
    if (pt.getX() > Max(offsides_line, ballx)) {
      actionlog(250) << "IsOffsidesPosition(l): true " << pt.getX() << " > ("
		     << offsides_line << ", " << ballx << ")" << ende;
      return true;
    } else {
      actionlog(250) << "IsOffsidesPosition(l): false " << pt.getX() << " !> ("
		     << offsides_line << ", " << ballx << ")" << ende;
      return false;
    }
  } else {
    if (pt.getX() < Min(offsides_line, ballx)) {
      actionlog(250) << "IsOffsidesPosition(l): true " << pt.getX() << " < ("
		     << offsides_line << ", " << ballx << ")" << ende;
      return true;
    } else {
      actionlog(250) << "IsOffsidesPosition(l): true " << pt.getX() << " !< ("
		     << offsides_line << ", " << ballx << ")" << ende;
      return false;
    }
  }
}

float XToOnsideX(TeamSide my_side, float x, float offsides_line)
{
  if (my_side == TS_Left) {
    return Min(x, offsides_line);
  } else {
    return Max(x, offsides_line);
  }
}

float XToOnHalfX(TeamSide my_side, float x, float buffer)
{
  if (my_side == TS_Left) {
    return Min(x, -buffer);
  } else {
    return Max(x,  buffer);
  }
}



bool IsPassTooFarOffsides(TeamSide my_side, VecPosition start, VecPosition end, float offsides_line)
{
  if (!IsOffsidesPosition(my_side, end, offsides_line))
    return false; //not an offsides pass at all!
    
  float ball_cycles = CoachParam::instance()->getTeamMinCyclesToKick() + 
    Geometry::getLengthGeomSeries(CoachParam::instance()->getTeamMaxKickSpeed(),
				  ServerParam::instance()->getSPBallDecay(),
				  start.getDistanceTo(end));
  float player_cycles = CoachParam::instance()->getSppEvalOffplayDelay() +
    fabs(end.getX()-offsides_line) / 
    (CoachParam::instance()->getSppEvalOffplayPercSpeed()*ServerParam::instance()->getSPPlayerSpeedMax());

  actionlog(250) << "IsPassTooFarOffsides: " << ball_cycles << " " << player_cycles << ende;
  
  return (ball_cycles < player_cycles);
}

