/* -*- Mode: C++ -*- */
/* opp_models.h: this defines a bunch of opponent models for the coach to use in planning */

#ifndef _OPP_MODELS_H_
#define _OPP_MODELS_H_

#include "OppModel.h"
#include "data.h"

/* NOTE: predictMovement needs to be able to handle the case where pd and returner
   point to the same object! */

//players which never move
class OM_Stones : public OppModel {
public:
  OM_Stones() : OppModel() {}
  void predictMovement(PlayerDistribution* pd,
		       PlayerDistribution* returner,
		       BallMovement* bm);
  const char* GetName() { return "Stones"; }
} ;

//players which never move, but their variance spreads
class OM_SpreadingStones : public OppModel {
public:
  //var_drift is stdev increase per cycles
  OM_SpreadingStones(float var_drift_tmp = .2);
  void predictMovement(PlayerDistribution* pd,
		       PlayerDistribution* returner,
		       BallMovement* bm);
  const char* GetName() { return name; }

private:
  float var_drift;  
  char name[50];  
} ;

class OM_AlwaysLeft : public OppModel {
public:
  OM_AlwaysLeft() : OppModel() {}
  void predictMovement(PlayerDistribution* pd,
		       PlayerDistribution* returner,
		       BallMovement* bm);
  const char* GetName() { return "AlwaysLeft"; }
} ;

class OM_AlwaysRight : public OppModel {
public:
  OM_AlwaysRight() : OppModel() {}
  void predictMovement(PlayerDistribution* pd,
		       PlayerDistribution* returner,
		       BallMovement* bm);
  const char* GetName() { return "AlwaysRight"; }
} ;

class OM_NGoToBall : public OppModel {
public:
  //var_drift is stdev increase per cycles
  OM_NGoToBall(int n, float speed_tmp, float var_drift_tmp = .2);
  virtual ~OM_NGoToBall() { delete pRecBest; }
  void predictMovement(PlayerDistribution* pd,
		       PlayerDistribution* returner,
		       BallMovement* bm);
  const char* GetName() { return name; }

private:
  char name[50];  

  int num_to_ball;
  float speed;
  float var_drift;

  RecordBestN* pRecBest;
} ;



#endif
