/* -*- Mode: C++ -*- */

/* This file contains pieces to build up models for model matching testing */

#ifndef _MODEL_TEST_H_
#define _MODEL_TEST_H_

#include "PlayerDistribution.h"
#include "OppModel.h"

/* This is a big old hack. The functions below want access to goal positions
   This functions will set those into file static variables. that the below funcs
   can access */
void setModelTestSide(TeamSide ts);

/* These are the important individual skill things */
void mt_model_nomove(float spd, float var_change, float time,
		    Variable2DGaussian* pFrom, Variable2DGaussian* pTo);
void mt_model_def(float spd, float var_change, float time,
		 Variable2DGaussian* pFrom, Variable2DGaussian* pTo);
void mt_model_off(float spd, float var_change, float time,
		 Variable2DGaussian* pFrom, Variable2DGaussian* pTo);
void mt_model_defgoal(float spd, float var_change, float time,
		     Variable2DGaussian* pFrom, Variable2DGaussian* pTo);
void mt_model_offgoal(float spd, float var_change, float time,
		     Variable2DGaussian* pFrom, Variable2DGaussian* pTo);
void mt_model_ball(float spd, float var_change, float time, VecPosition ball_pos,
		  Variable2DGaussian* pFrom, Variable2DGaussian* pTo);
void mt_model_ballint(float spd, float var_change, float time,
		     VecPosition ball_pos, VecPosition ball_vel,
		     Variable2DGaussian* pFrom, Variable2DGaussian* pTo);

class OM_AllNoMove : public OppModel {
public:
  //var_drift is stdev increase per cycles
  OM_AllNoMove(float var_drift_tmp = .4) 
    {var_drift = var_drift_tmp; }
  void predictMovement(PlayerDistribution* pd,
		       PlayerDistribution* returner,
		       BallMovement* bm);
  const char* GetName() { return "1"; }
private:
  float var_drift;  
} ;

class OM_AllBall : public OppModel {
public:
  //var_drift is stdev increase per cycles
  OM_AllBall(float var_drift_tmp = .4, float spd_tmp = .6) 
    {var_drift = var_drift_tmp; spd = spd_tmp;}
  void predictMovement(PlayerDistribution* pd,
		       PlayerDistribution* returner,
		       BallMovement* bm);
  const char* GetName() { return "2"; }
private:
  float var_drift;  
  float spd;
} ;

class OM_AllDef : public OppModel {
public:
  //var_drift is stdev increase per cycles
  OM_AllDef(float var_drift_tmp = .4, float spd_tmp = .6) 
    {var_drift = var_drift_tmp; spd = spd_tmp;}
  void predictMovement(PlayerDistribution* pd,
		       PlayerDistribution* returner,
		       BallMovement* bm);
  const char* GetName() { return "3"; }
private:
  float var_drift;  
  float spd;
} ;

class OM_AllOff : public OppModel {
public:
  //var_drift is stdev increase per cycles
  OM_AllOff(float var_drift_tmp = .4, float spd_tmp = .6) 
    {var_drift = var_drift_tmp; spd = spd_tmp;}
  void predictMovement(PlayerDistribution* pd,
		       PlayerDistribution* returner,
		       BallMovement* bm);
  const char* GetName() { return "4"; }
private:
  float var_drift;  
  float spd;
} ;

class OM_OneBall_NoMove : public OppModel {
public:
  //var_drift is stdev increase per cycles
  OM_OneBall_NoMove(float var_drift_tmp = .4, float spd_tmp = .6) 
    {var_drift = var_drift_tmp; spd = spd_tmp;}
  void predictMovement(PlayerDistribution* pd,
		       PlayerDistribution* returner,
		       BallMovement* bm);
  const char* GetName() { return "5"; }
private:
  float var_drift;  
  float spd;
} ;

/* one player goes to the ball, but it does the update incrementally so 
   that at every cycle the player closest to the ball is the one that goes 
   to the end point at every cycle */
class OM_OneBallIncr_NoMove : public OppModel {
public:
  //var_drift is stdev increase per cycles
  OM_OneBallIncr_NoMove(float var_drift_tmp = .4, float spd_tmp = .6) 
    {var_drift = var_drift_tmp; spd = spd_tmp;}
  void predictMovement(PlayerDistribution* pd,
		       PlayerDistribution* returner,
		       BallMovement* bm);
  const char* GetName() { return "5"; }
private:
  float var_drift;  
  float spd;
} ;


#endif
