/* -*- Mode: C++ -*- */

/* This file contains pieces to build up execution units for model matching testing */

#include "model_test.h"
#include "misc.h"
#include "ServerParam.h"
#include "CoachParam.h"
#include "Logger.h"
using namespace spades;

/*********************************************************************/
/* This is a big old hack. The functions below want access to goal positions
   This functions will set those into file static variables. that the below funcs
   can access */

static bool s_model_test_my_side_set = false;
static TeamSide s_model_test_my_side;
static TeamSide s_model_test_their_side;

void
setModelTestSide(TeamSide ts)
{
  s_model_test_my_side = ts;
  s_model_test_their_side = relativeTeamSideToAbs(RTS_Theirs, ts);
  s_model_test_my_side_set = (ts == TS_Left || ts == TS_Right);
}


/*********************************************************************/
/* Helper functions */
int GetMeanClosestTo(PlayerDistribution* pd, VecPosition pt)
{
  float len = 10000;
  float temp_len;
  int best_idx = -1;
  for (int num=1; num <= ServerParam::instance()->getSPTeamSize(); num++) {
    if (len > (temp_len=pd->getPlayDist(num)->GetMean().getDistanceTo(pt))) {
      best_idx = num;
      len = temp_len;
    }
  }
  return best_idx;
}


/*********************************************************************/
/* These are the important individual skill things */
void mt_model_nomove(float spd, float var_change, float time,
		    Variable2DGaussian* pFrom, Variable2DGaussian* pTo)
{
  if (!s_model_test_my_side_set)
    errorlog << "Must have set the goal positions to use model_test!" << ende;
  pTo->copyFrom(pFrom);
  pTo->SetXStdev(Max(.5, pTo->GetXStdevPlus() + var_change), 
		 Max(.5, pTo->GetXStdevMinus() + var_change));
  pTo->SetYStdev(Max(.5, pTo->GetYStdevPlus() + var_change), 
		 Max(.5, pTo->GetYStdevMinus() + var_change));
}

void mt_model_def(float spd, float var_change, float time,
		 Variable2DGaussian* pFrom, Variable2DGaussian* pTo)
{
  if (!s_model_test_my_side_set)
    errorlog << "Must have set the goal positions to use model_test!" << ende;
  pTo->copyFrom(pFrom);
  pTo->SetXStdev(Max(.5, pTo->GetXStdevPlus() + var_change), 
		 Max(.5, pTo->GetXStdevMinus() + var_change));
  pTo->SetYStdev(Max(.5, pTo->GetYStdevPlus() + var_change), 
		 Max(.5, pTo->GetYStdevMinus() + var_change));
  pTo->SetMean(ServerParam::instance()->getSPFieldRectangle().adjustToWithin(pFrom->GetMean() + 
						  getGoalPosForSide(s_model_test_their_side).scaleTo(spd*time), 0 ));
}

void mt_model_off(float spd, float var_change, float time,
		 Variable2DGaussian* pFrom, Variable2DGaussian* pTo)
{
  if (!s_model_test_my_side_set)
    errorlog << "Must have set the goal positions to use model_test!" << ende;
  pTo->copyFrom(pFrom);
  pTo->SetXStdev(Max(.5, pTo->GetXStdevPlus() + var_change), 
		 Max(.5, pTo->GetXStdevMinus() + var_change));
  pTo->SetYStdev(Max(.5, pTo->GetYStdevPlus() + var_change), 
		 Max(.5, pTo->GetYStdevMinus() + var_change));
  pTo->SetMean(ServerParam::instance()->getSPFieldRectangle().adjustToWithin(pFrom->GetMean() + 
						  getGoalPosForSide(s_model_test_my_side).scaleTo(spd*time), 0 ));
}

void mt_model_defgoal(float spd, float var_change, float time,
		     Variable2DGaussian* pFrom, Variable2DGaussian* pTo)
{
  if (!s_model_test_my_side_set)
    errorlog << "Must have set the goal positions to use model_test!" << ende;
  pTo->copyFrom(pFrom);
  pTo->SetXStdev(Max(.5, pTo->GetXStdevPlus() + var_change), 
		 Max(.5, pTo->GetXStdevMinus() + var_change));
  pTo->SetYStdev(Max(.5, pTo->GetYStdevPlus() + var_change), 
		 Max(.5, pTo->GetYStdevMinus() + var_change));
  pTo->SetMean(ServerParam::instance()->getSPFieldRectangle().adjustToWithin(pFrom->GetMean() + 
						  (getGoalPosForSide(s_model_test_their_side)-pFrom->GetMean()).scaleTo(spd*time), 0 ));
}

void mt_model_offgoal(float spd, float var_change, float time,
		     Variable2DGaussian* pFrom, Variable2DGaussian* pTo)
{
  if (!s_model_test_my_side_set)
    errorlog << "Must have set the goal positions to use model_test!" << ende;
  pTo->copyFrom(pFrom);
  pTo->SetXStdev(Max(.5, pTo->GetXStdevPlus() + var_change), 
		 Max(.5, pTo->GetXStdevMinus() + var_change));
  pTo->SetYStdev(Max(.5, pTo->GetYStdevPlus() + var_change), 
		 Max(.5, pTo->GetYStdevMinus() + var_change));
  pTo->SetMean(ServerParam::instance()->getSPFieldRectangle().adjustToWithin(pFrom->GetMean() + 
						  (getGoalPosForSide(s_model_test_my_side)-pFrom->GetMean()).scaleTo(spd*time), 0 ));
}

void mt_model_ball(float spd, float var_change, float time, VecPosition ball_pos,
		  Variable2DGaussian* pFrom, Variable2DGaussian* pTo)
{
  if (!s_model_test_my_side_set)
    errorlog << "Must have set the goal positions to use model_test!" << ende;
  pTo->copyFrom(pFrom);
  pTo->SetXStdev(Max(.5, pTo->GetXStdevPlus() + var_change), 
		 Max(.5, pTo->GetXStdevMinus() + var_change));
  pTo->SetYStdev(Max(.5, pTo->GetYStdevPlus() + var_change), 
		 Max(.5, pTo->GetYStdevMinus() + var_change));
  pTo->SetMean(ServerParam::instance()->getSPFieldRectangle().adjustToWithin(pFrom->GetMean() + 
						  (ball_pos-pFrom->GetMean()).scaleTo(spd*time), 0 ));
}

void mt_model_ballint(float spd, float var_change, float time,
		     VecPosition ball_pos, VecPosition ball_vel,
		     Variable2DGaussian* pFrom, Variable2DGaussian* pTo)
{
  errorlog << "Don't model ball interception yet" << ende;
}

/*********************************************************************/

void OM_AllNoMove::predictMovement(PlayerDistribution* pd,
				   PlayerDistribution* returner,
				   BallMovement* bm)
{
  int total_time = bm->getTotalTime();
  
  returner->copyFrom(pd);

  for (int num=1; num <= ServerParam::instance()->getSPTeamSize(); num++) {
    mt_model_nomove(0.0, var_drift*total_time, total_time, 
		    pd->getPlayDist(num), returner->getPlayDist(num));
  }
}

void OM_AllBall::predictMovement(PlayerDistribution* pd,
				 PlayerDistribution* returner,
				 BallMovement* bm)
{
  int total_time = bm->getTotalTime();
  
  returner->copyFrom(pd);

  for (int num=1; num <= ServerParam::instance()->getSPTeamSize(); num++) {
    mt_model_ball(spd, var_drift*total_time, total_time, bm->getFinalPosition(),
		  pd->getPlayDist(num), returner->getPlayDist(num));
  }
}

void OM_AllDef::predictMovement(PlayerDistribution* pd,
				PlayerDistribution* returner,
				BallMovement* bm)
{
  int total_time = bm->getTotalTime();
  
  returner->copyFrom(pd);

  for (int num=1; num <= ServerParam::instance()->getSPTeamSize(); num++) {
    mt_model_def(spd, var_drift*total_time, total_time, 
		 pd->getPlayDist(num), returner->getPlayDist(num));
  }
}

void OM_AllOff::predictMovement(PlayerDistribution* pd,
				PlayerDistribution* returner,
				BallMovement* bm)
{
  int total_time = bm->getTotalTime();
  
  returner->copyFrom(pd);

  for (int num=1; num <= ServerParam::instance()->getSPTeamSize(); num++) {
    mt_model_off(spd, var_drift*total_time, total_time, 
		 pd->getPlayDist(num), returner->getPlayDist(num));
  }
}


void OM_OneBall_NoMove::predictMovement(PlayerDistribution* pd,
				   PlayerDistribution* returner,
				   BallMovement* bm)
{
  int total_time = bm->getTotalTime();
  
  returner->copyFrom(pd);

  VecPosition end = bm->getFinalPosition();
  int best_idx = GetMeanClosestTo(pd, end);

  for (int num=1; num <= ServerParam::instance()->getSPTeamSize(); num++) {
    if (num == best_idx) 
      mt_model_ball(spd, var_drift*total_time, total_time, end,
		    pd->getPlayDist(num), returner->getPlayDist(num));
    else
      mt_model_nomove(0.0, var_drift*total_time, total_time, 
		      pd->getPlayDist(num), returner->getPlayDist(num));
  }
}

/* This assumes that the ball travels in a straight line from first
   to last point */
void OM_OneBallIncr_NoMove::predictMovement(PlayerDistribution* pd,
				   PlayerDistribution* returner,
				   BallMovement* bm)
{
  int total_time = bm->getTotalTime();
  int prev_close = -1, time_closest= 0;
  
  returner->copyFrom(pd);

  VecPosition start = bm->getBallPosition(0);
  VecPosition end = bm->getFinalPosition();
  VecPosition ball_vel =
    Geometry::getFirstGeomSeries(start.getDistanceTo(end),
				 ServerParam::instance()->getSPBallDecay(),
				 total_time);
  VecPosition ball_pos = start;
  
  for (int t = 0; t < total_time; t++) {
    int close_player = GetMeanClosestTo(returner, ball_pos);
    for (int num=1; num <= ServerParam::instance()->getSPTeamSize(); num++) {
      Variable2DGaussian* dist = returner->getPlayDist(num);
      if (num == close_player && 
	  (CoachParam::instance()->getSppOmPlayerDelay() <= 0 ||
	   (close_player == prev_close && time_closest >= CoachParam::instance()->getSppOmPlayerDelay()))) {
	dist->SetXStdev(dist->GetXStdevPlus() + var_drift, 
		       dist->GetXStdevMinus() + var_drift);
	dist->SetYStdev(dist->GetYStdevPlus() + var_drift, 
			dist->GetYStdevMinus() + var_drift);
	dist->SetMean(ServerParam::instance()->getSPFieldRectangle().adjustToWithin(dist->GetMean() + 
							 (end-dist->GetMean()).scaleTo(spd), 0 ));
      } else {
	dist->SetXStdev(dist->GetXStdevPlus() + var_drift, 
		       dist->GetXStdevMinus() + var_drift);
	dist->SetYStdev(dist->GetYStdevPlus() + var_drift, 
			dist->GetYStdevMinus() + var_drift);
      }
    }
    if (close_player == prev_close) {
      time_closest++;
    } else {
      prev_close = close_player;
      time_closest = 1;
    }
    ball_pos += ball_vel;
    ball_vel *= ServerParam::instance()->getSPBallDecay();
  }
  

}

