#include "TestFunction.h"

#include <stdio.h>

TestFunction::TestFunction(void) 
  : ControllerFunction("Test")
{
  thrd_status = 0;  
}


void* TestFunction::asynch_worker() 
{
  while(1) {
    thrd_status = 3;    
    pthread_mutex_lock(&mutex_data_ready);
    while (!data_ready) {
      pthread_cond_wait(&cv_data_ready, &mutex_data_ready);
    }
    pthread_mutex_unlock(&mutex_data_ready);
    
    thrd_status = 1;
    //acquire data mutex
    //copy data
    //release data mutex

    //indicate that more data could be put in now
    pthread_mutex_lock(&mutex_data_ready);
    data_ready = false;    
    pthread_mutex_unlock(&mutex_data_ready);

    //do your work
    for (int i=0; i<10000; i++) {
      for (int j=0; j<10000; j++) {
      }
    }
    
    thrd_status = 2;
    
  }
  return NULL;
}


void TestFunction::PrintThrdStatus(char* str) 
{
  char status_strs[4][30] = {"not started", "running", "finished a run", "on cond var"};

  printf("%s: %s\n", str, status_strs[thrd_status]);
}

void TestFunction::GiveMoreData()
{
  //acquire data mutex
  // might want to notice whether data_ready is true or not- if it is, it probably 
  // means that the worked thread didn't have time to copy out the data
  //put data in vars
  //release data mutex

  pthread_mutex_lock(&mutex_data_ready);
  data_ready = true;    
  pthread_cond_signal(&cv_data_ready);
  pthread_mutex_unlock(&mutex_data_ready);
}
