/* -*- Mode: C++ -*- */

/* This file contains some planner modules to be used in the FourLevelPlanner (see 
   FourLevelPlanner.[Ch] that are not specific to the coach or player */

#ifndef _SHARE_PLANNER_MODULES_H_	
#define _SHARE_PLANNER_MODULES_H_ 

#include "FourLevelPlanner.h"

/************************* Level -: Getting Initial Position **************/
/* this isn't really a level, but in order to make this usable for
   both coach and player we need to have a function which compilies the
   current position into a PlayerDistribution */

class DoNothingGPD : public GetPlayerDistribution
{
public:
  void SetPositions(PlayerDistribution* pd) 
    {}
  
} ;


/************************* Level 1: Waypoint ****************************/
class DoNothingWP : public Waypoint 
{
 public:
  DoNothingWP() : Waypoint() {}
  ~DoNothingWP() {}

  bool run(Problem* theProb, PlayerDistribution* pDist, GetPlayerDistribution* getPD, 
	   WaypointList* output)
    { return true; }
  
} ;

/************************* Level 2: RoleMaker ****************************/
class DoNothingRM : public RoleMaker
{
 public:
  DoNothingRM() : RoleMaker() {}
  ~DoNothingRM() {}
  
  bool run(WaypointList* pWaypoints, Problem* theProb, AgentBallMovements* output) 
    { return true; }
} ;

/************************* Level 3: STNCompilation ****************************/
/* First some handy uility functions */
bool AddBallOrderEdges(Plan* p);
bool AddPlayerOrderEdges(Plan* p);

class DoNothingSTNC : public STNCompilation
{
 public:
  DoNothingSTNC() : STNCompilation() {}
  ~DoNothingSTNC() {}

  bool run(AgentBallMovements* pMoves, Problem* theProb, Plan* output) 
    { return true; }
} ;

class OnlyInitialPosSTNC : public STNCompilation
{
 public:
  OnlyInitialPosSTNC() : STNCompilation() {}

  bool run(AgentBallMovements* pMoves, Problem* theProb, Plan* output);  
} ;

class FullSTNC : public STNCompilation
{
 public:
  FullSTNC() : STNCompilation() {}

  bool run(AgentBallMovements* pMoves, Problem* theProb, Plan* output);  
} ;


/************************* Level 4: AgentInstantiation ****************************/
class DoNothingAI : public AgentInstantiation
{
 public:
  DoNothingAI() : AgentInstantiation() {}

  bool run(Plan* thePlan, Problem* theProb)
    { return true; }
} ;

class JustSpinAI : public AgentInstantiation
{
 public:
  JustSpinAI() : AgentInstantiation() {}

  bool run(Plan* thePlan, Problem* theProb)
    { while(1) if (*pTimeLeft == TL_Abort) break; return false;}
} ;

class SequentialAI : public AgentInstantiation
{
 public:
  SequentialAI(int num = 1) : AgentInstantiation() { start_num = num; }

  bool run(Plan* thePlan, Problem* theProb);
private:
  int start_num;  
} ;


#endif //_SHARE_PLANNER_MODULES_H
