/* -*- Mode: C++ -*- */

/* This file contains the four modules for the planning architecture for the player */

#ifndef _SHARE_PLAN_MODULES_H_
#define _SHARE_PLAN_MODULES_H_

#include "Monitor.h"
#include "Diagnosis.h"
#include "Planner.h"
#include "Executor.h"
#include "Logger.h"

/***********************************************************************************/
/*******************                Monitor                        *****************/
/***********************************************************************************/

//randomly marks ready events as completed
class RandomMarkCompletedMonitor : public Monitor 
{
public:
  RandomMarkCompletedMonitor() : Monitor() {};  

  monitor_return_t run(PlanExecution* plan_exec);

  void* asynch_worker() 
  { errorlog << "RandomMarkCompletedMonitor: don't run me asynch!" << spades::ende; return NULL;}
};

//MakeReady was moved to PlanExecution to be automatically done on SetExecTime

//watches for violations in the time bounds of the STN
class WatchTimeViolationMonitor : public Monitor 
{
public:
  WatchTimeViolationMonitor() : Monitor() {};  

  monitor_return_t run(PlanExecution* plan_exec);

  void* asynch_worker() 
  { errorlog << "WatchTimeViolationMonitor: don't run me asynch!" << spades::ende; return NULL;}
};



/***********************************************************************************/
/*******************                Diagnosis                      *****************/
/***********************************************************************************/

class AlwaysFailDiagnosis : public Diagnosis
{
public:
  AlwaysFailDiagnosis() : Diagnosis() {};
  
  diagnosis_return_t run(PlanExecution* plan_exec) 
  { return DR_Failure; };

  void* asynch_worker() 
  { errorlog << "AlwaysFailDiagnosis: don't run me asynch!" << spades::ende; return NULL;}  
};

/***********************************************************************************/
/*******************                Planner                        *****************/
/***********************************************************************************/

class AlwaysStallPlanner : public Planner
{
public:
  AlwaysStallPlanner() : Planner() {};
  
  planner_return_t run(Problem* theProblem, Plan* thePlan) 
  { return PlnRet_NotReadyYet; };

  void* asynch_worker() 
  { errorlog << "AlwaysStallPlanner: don't run me asynch!" << spades::ende; return NULL;}    
};

/***********************************************************************************/
/*******************                Executor                       *****************/
/***********************************************************************************/


#endif
