/* This file contains shared modules for four box controller */

#include "ShareContModules.h"
#include "soccer_utils.h"
#include "Logger.h"
using namespace spades;

/***********************************************************************************/
/*******************                Monitor                        *****************/
/***********************************************************************************/

monitor_return_t RandomMarkCompletedMonitor::run(PlanExecution* plan_exec)
{
  if (plan_exec->GetUnderlyingPlan() == NULL)
    return MR_Normal;  
  for (int idx = 0; idx < plan_exec->GetUnderlyingPlan()->GetNumNodes(); idx++) {
    if (plan_exec->GetNodeStatus(idx) != NS_Ready) {
      actionlog(220) << "Node " << idx << "(" << GetPlanNodeName(plan_exec->GetPlanNode(idx)->GetType())
		     << ") status: " << plan_exec->GetNodeStatus(idx)
		     << ", so can't complete"
		     << ende;	
      continue; //only pending nodes become ready
    }
    
    if (int_random(7) == 0) {
      actionlog(40) << "Node " << idx << "(" << GetPlanNodeName(plan_exec->GetPlanNode(idx)->GetType())
		    << ") completed"
		    << ende;	
      plan_exec->SetNodeExecTime(idx, plan_exec->getCurrentTime());
    }    
  }
  return MR_Normal;  
}


monitor_return_t WatchTimeViolationMonitor::run(PlanExecution* plan_exec)
{
  if (plan_exec->GetUnderlyingPlan() == NULL)
    return MR_Normal;  
  if (plan_exec->CheckConsistency()) {
    return MR_Normal;
  } else {
    actionlog(30) << "Plan no longer consistent!" << ende;
    return MR_Deviation;    
  }
}




/***********************************************************************************/
/*******************                Diagnosis                      *****************/
/***********************************************************************************/

/***********************************************************************************/
/*******************                Planner                        *****************/
/***********************************************************************************/

/***********************************************************************************/
/*******************                Executor                       *****************/
/***********************************************************************************/


