/* -*- Mode: C++ -*- */

#include "Problem.h"
#include "ServerParam.h"
#include "Logger.h"
using namespace spades;

Problem::Problem() 
{ 
  mode = SPM_No_Mode; 
  spec_mode = SSPM_No_Mode; 
  ball_pos = 0; 
  fresh = false;
}

void Problem::SetSpecMode(bool am_left)
{
  //these are all given for the left team
  float ki_def_mid_x = -15;
  float ki_mid_off_x =  15;
  float fk_kick_in_buff = 5;
  float fk_low_mid = 15;
  float fk_mid_upp = -15;

  VecPosition tmp_ball_pos = ball_pos;
  
  if (!am_left) {
    tmp_ball_pos = tmp_ball_pos.flipX();
  }

  spec_mode = SSPM_No_Mode;
  switch (mode) {
  case SPM_No_Mode:
    spec_mode = SSPM_No_Mode;
    break;
  case SPM_My_Kick_Off:
    spec_mode = SSPM_My_Kick_Off;
    break;
  case SPM_Their_Kick_Off:
    spec_mode = SSPM_Their_Kick_Off;
    break;
  case SPM_My_Corner_Kick:
    spec_mode = SSPM_My_Corner_Kick;
    break;
  case SPM_Their_Corner_Kick:
    spec_mode = SSPM_Their_Corner_Kick;
    break;
  case SPM_My_Goal_Kick:
    spec_mode = SSPM_My_Goal_Kick;
    break;
  case SPM_Their_Goal_Kick:
    spec_mode = SSPM_Their_Goal_Kick;
    break;
  case SPM_My_Goalie_Catch:
    spec_mode = SSPM_My_Goalie_Catch;
    break;
  case SPM_Their_Goalie_Catch:
    spec_mode = SSPM_Their_Goalie_Catch;
    break;

  case SPM_My_Free_Kick:
    if (ServerParam::instance()->getSPPitchWidth() / 2 - fabs(tmp_ball_pos.getY()) < fk_kick_in_buff)
      ;//FALL THROUGH TO KICK IN!
    else {
      if (tmp_ball_pos.getY() > fk_low_mid)
	spec_mode = SSPM_My_Free_Kick_Lower;
      else if (tmp_ball_pos.getY() > fk_mid_upp)
	spec_mode = SSPM_My_Free_Kick_Mid;
      else
	spec_mode = SSPM_My_Free_Kick_Upper;
      break;
    }
  case SPM_My_Kick_In:
    if (tmp_ball_pos.getX() < ki_def_mid_x)
      spec_mode = SSPM_My_Kick_In_Def;
    else if (tmp_ball_pos.getX() < ki_mid_off_x)
      spec_mode = SSPM_My_Kick_In_Mid;
    else
      spec_mode = SSPM_My_Kick_In_Off;
    break;

  case SPM_Their_Free_Kick:
    if (ServerParam::instance()->getSPPitchWidth() / 2 - fabs(tmp_ball_pos.getY()) < fk_kick_in_buff)
      ;//FALL THROUGH TO KICK IN!
    else {
      if (tmp_ball_pos.getY() > fk_low_mid)
	spec_mode = SSPM_Their_Free_Kick_Lower;
      else if (tmp_ball_pos.getY() > fk_mid_upp)
	spec_mode = SSPM_Their_Free_Kick_Mid;
      else
	spec_mode = SSPM_Their_Free_Kick_Upper;
      break;
    }
  case SPM_Their_Kick_In:
    tmp_ball_pos = tmp_ball_pos.flipX();
    if (tmp_ball_pos.getX() < ki_def_mid_x)
      spec_mode = SSPM_Their_Kick_In_Def;
    else if (tmp_ball_pos.getX() < ki_mid_off_x)
      spec_mode = SSPM_Their_Kick_In_Mid;
    else
      spec_mode = SSPM_Their_Kick_In_Off;
    break;


  default:
    errorlog << "Problem: what is mode? " << mode << ende;
    break;
  }
  
}

  


