/* -*- Mode: C++ -*- */

#ifndef _PlayerDistribution_h_
#define _PlayerDistribution_h_
#include <stdlib.h>
#include <iostream.h>
#include "Geometry.h"
#include "misc.h"
#include "PlanNode.h"

/* Originally, this was going to be a virtual base class for different dist implementations,
   but for now, it's easier to just implement the gaussian thing here */

/* This is a gaussian in 2d, where you specifiy a different variance for positive and negative
   x and y directions, and you specify a rotation on the gaussian */
/* Right now, this thing won't necessarily give you a probability distribution- things might not
   sum to 1, but it kind of does the right thing */
#define BIN_XDIM 1.0
#define BIN_YDIM 1.0
class Variable2DGaussian {
public:
  Variable2DGaussian();
  //no dynamic memory, so no destructor
  //~Variable2DGaussian();

  void clear(); // mean (0,0), not rot, stdev = 1
  void copyFrom(Variable2DGaussian* master) 
    { if (master == this) return;
    mean = master->mean; 
    xstdev_plus = master->xstdev_plus; xstdev_minus = master->xstdev_minus; 
    ystdev_plus = master->ystdev_plus; ystdev_minus = master->ystdev_minus;
    rot_ang = master->rot_ang; 
    }
      

  void SetMean(VecPosition v) { mean = v; }
  //you can set all of these to 0, but if only some of them are, you will get weird things
  void SetXStdev(double plus, double minus);
  void SetYStdev(double plus, double minus);
  void SetStdev(double stdev) 
  { SetXStdev(stdev, stdev); SetYStdev(stdev, stdev); }
  void SetRotAng(double a) { rot_ang = a; }

  VecPosition GetMean() { return mean; }
  float GetXStdevPlus()  { return xstdev_plus; }
  float GetXStdevMinus() { return xstdev_minus; }
  float GetYStdevPlus()  { return ystdev_plus; }
  float GetYStdevMinus() { return ystdev_minus; }
    
  //PDF is probability density function
  double GetPDF(VecPosition pt);
    
  //Gets the (approximate) probability mass function for the 1x1 bin with center at pt
  //*Simple means that it just averages the corners
  double GetBinPMFSimple(VecPosition pt); 
  double GetBinPMF(VecPosition pt); 

  void PrintBins(float xmin, float xmax, float ymin, float ymax, bool showvals = true);
  void PrintSimplifiedBins(ostream& out,
			   float xmin, float xmax, float ymin, float ymax, 
			   float binsize, VecPosition mark = VecPosition(-1000, -1000))
    { PrintSimplifiedBins(out, xmin, xmax, ymin, ymax, binsize, binsize, mark); }
      
  void PrintSimplifiedBins(ostream& out, 
			   float xmin, float xmax, float ymin, float ymax, 
			   float xbinsize, float ybinsize, 
			   VecPosition mark = VecPosition(-1000, -1000));
  void PrintSimplifiedBins(ostream& out, 
			   VecPosition mark = VecPosition(-1000, -1000));

  VecPosition GenerateSample();
  
private:

  //asumes mean of 0
  double GetPDFWithStdev(VecPosition pt, double xstd, double ystd) 
   { return gaussian_func(pt.getX(), 0.0, xstd) * gaussian_func(pt.getY(), 0.0, ystd); } 

  // assumed mean 0 with no rotation
  double evalPMFRect(VecPosition ul, VecPosition br);

  VecPosition mean;
  double xstdev_plus, xstdev_minus;
  double ystdev_plus, ystdev_minus;
  double rot_ang;
} ;

class PlayerDistribution {
  
public:
  //PlayerDistribution(void); 
  //~PlayerDistribution(void);
  //player i in location i-1
  void setInitial(VecPosition* initPos);
  void setInitialForPlayer(int num, VecPosition initPos);
  double getValue(int player, VecPosition pt);
  void clear(void);
  void copyFrom(PlayerDistribution* master);

  float getSumOcc(VecPosition pt);

  //true means we are left team, these are the opponents, and we want our offensive
  //offsides line
  float getOffsidesLine(bool amILeft);

  Variable2DGaussian* getPlayDist(int num) 
    {return &player_dist[num-1]; }
  
  void PrintAllDistSimplified(ostream& out, PlayerDistribution* pMark = NULL);

private:
  //we should probably allocate this dynamically, but we won't for speed
  Variable2DGaussian player_dist[NUM_PLAYERS];
};

#endif
  
