#include<stdlib.h>
#include<iostream.h>

#include "PlayerDistribution.h"
#include <iostream.h>
#include <iomanip.h>
#include "ServerParam.h"
#include "data.h"
#include "Logger.h"
using namespace spades;


/***************************** Variable2dGaussian ***************************/

Variable2DGaussian::Variable2DGaussian()
{
  clear();
}

void Variable2DGaussian::clear()
{
  mean = VecPosition(0,0);
  xstdev_plus = 1.0;
  xstdev_minus = 1.0;
  ystdev_plus = 1.0;
  ystdev_minus = 1.0;
  rot_ang = 0;
}

void Variable2DGaussian::SetXStdev(double plus, double minus) 
{ 
  if (plus == 0.0 || minus == 0.0) {
    if (plus != 0.0 || minus != 0.0) {
      errorlog << "Can't set one of stdev to 0 and not other " << plus << " " << minus << ende;
      return;
    }
  }
  xstdev_plus = plus; 
  xstdev_minus = minus; 
}
void Variable2DGaussian::SetYStdev(double plus, double minus)
{ 
  if (plus == 0.0 || minus == 0.0) {
    if (plus != 0.0 || minus != 0.0) {
      errorlog << "Can't set one of stdev to 0 and not other " << plus << " " << minus << ende;
      return;
    }
  }
  ystdev_plus = plus; 
  ystdev_minus = minus; 
}


double Variable2DGaussian::GetPDF(VecPosition pt)
{
  double xstdev, ystdev;

  pt -= mean;
  pt = pt.rotate(rot_ang);

  if (pt.getX() >= 0)
    xstdev = xstdev_plus;
  else
    xstdev = xstdev_minus;

  if (pt.getY() >= 0)
    ystdev = ystdev_plus;
  else
    ystdev = ystdev_minus;

  return Min(GetPDFWithStdev(pt, xstdev, ystdev), 1.0);
}


/* Here, we just average the four corners, even if we go over the hump (which would mean
   that our answer is too low for sure */
double Variable2DGaussian::GetBinPMFSimple(VecPosition pt)
{
  errorlog << "You shouldn't use GetBinPMFSimple now!" << ende;

  double sum = 0.0;
  double p_xstdev, m_xstdev;
  double p_ystdev, m_ystdev;
  
  pt -= mean;
  pt = pt.rotate(rot_ang);

  if (pt.getX() >= BIN_XDIM / 2) {
    p_xstdev = xstdev_plus;
    m_xstdev = xstdev_plus;
  } else if (pt.getX() <= BIN_XDIM / 2) {
    p_xstdev = xstdev_minus;
    m_xstdev = xstdev_minus;
  } else {
    p_xstdev = xstdev_plus;
    m_xstdev = xstdev_minus;
  } 

  if (pt.getY() >= BIN_YDIM / 2) {
    p_ystdev = ystdev_plus;
    m_ystdev = ystdev_plus;
  } else if (pt.getY() <= BIN_YDIM / 2) {
    p_ystdev = ystdev_minus;
    m_ystdev = ystdev_minus;
  } else {
    p_ystdev = ystdev_plus;
    m_ystdev = ystdev_minus;
  } 

  /*
  cerr << "Start sum: " << pt.getX()+mean.getX() << " " << pt.getY()+mean.getY() << endl;
  cerr << " stdevs: " 
       << p_xstdev << " "
       << m_xstdev << " "
       << p_ystdev << " "
       << m_ystdev << endl;
       */
  sum += GetPDFWithStdev(pt + VecPosition( BIN_XDIM / 2,  BIN_YDIM / 2), p_xstdev, p_ystdev);
  //cerr << "      sum: " << sum << endl;
  sum += GetPDFWithStdev(pt + VecPosition( BIN_XDIM / 2, -BIN_YDIM / 2), p_xstdev, m_ystdev);
  //cerr << "      sum: " << sum << endl;
  sum += GetPDFWithStdev(pt + VecPosition(-BIN_XDIM / 2,  BIN_YDIM / 2), m_xstdev, p_ystdev);
  //cerr << "      sum: " << sum << endl;
  sum += GetPDFWithStdev(pt + VecPosition(-BIN_XDIM / 2, -BIN_YDIM / 2), m_xstdev, m_ystdev);
  //cerr << "      sum: " << sum << endl;


  return sum / 4.0;
}

#ifdef OLD_CODE
  /*
  sum += gaussian_func(Sqr(pt.getX() + BIN_XDIM / 2) / p_xstdev + 
		       Sqr(pt.getY() + BIN_YDIM / 2) / p_ystdev);
  cerr << "      sum: " << sum << endl;
  sum += gaussian_func(Sqr(pt.getX() + BIN_XDIM / 2) / p_xstdev + 
		       Sqr(pt.getY() - BIN_YDIM / 2) / m_ystdev);
  cerr << "      sum: " << sum << endl;
  sum += gaussian_func(Sqr(pt.getX() - BIN_XDIM / 2) / m_xstdev + 
		       Sqr(pt.getY() + BIN_YDIM / 2) / p_ystdev);
  cerr << "      sum: " << sum << endl;
  sum += gaussian_func(Sqr(pt.getX() - BIN_XDIM / 2) / m_xstdev + 
		       Sqr(pt.getY() - BIN_YDIM / 2) / m_ystdev);
  cerr << "      sum: " << sum << endl;

  sum = gaussian_func(Sqr(pt.getX()) / p_xstdev + Sqr(pt.getY()) / p_ystdev);
  sum = gaussian_func(Sqr(pt.getX() + BIN_XDIM / 2) / p_xstdev + 
		       Sqr(pt.getY() + BIN_YDIM / 2) / p_ystdev);
		       */

#endif

double Variable2DGaussian::GetBinPMF(VecPosition pt)
{
  pt -= mean;
  pt = pt.rotate(rot_ang);

  if (xstdev_plus == 0.0) {
    if (ystdev_plus == 0.0) {
      return (fabs(pt.getX() - mean.getX()) <= BIN_XDIM/2 &&
	      fabs(pt.getY() - mean.getY()) <= BIN_YDIM/2) ? 1.0 : 0.0;
    }
  } 

  return evalPMFRect(VecPosition(pt.getX() - BIN_XDIM / 2, pt.getY() - BIN_YDIM / 2),
		     VecPosition(pt.getX() + BIN_XDIM / 2, pt.getY() + BIN_YDIM / 2));
}

double Variable2DGaussian::evalPMFRect(VecPosition ul, VecPosition br)
{
  //First, check to see if we cross the x-axis
  if (signf(ul.getX()) != signf(br.getX()) &&
      ul.getX() != 0.0 && br.getX() != 0.0) {
    //we cross the x-axis, so recurse
    return evalPMFRect(ul, VecPosition(0, br.getY())) + evalPMFRect(VecPosition(0, ul.getY()), br);
  }
  
  //Now check the y-axis
  if (signf(ul.getY()) != signf(br.getY()) &&
      ul.getY() != 0.0 && br.getY() != 0.0) {
    //we cross the y-axis, so recurse
    return evalPMFRect(ul, VecPosition(br.getX(), 0)) + evalPMFRect(VecPosition(ul.getX(), 0), br);
  }

  double xstdev, ystdev;
  float sum = 0.0;

  if (ul.getX() >= 0.0) {
    xstdev = xstdev_plus;
  } else {
    xstdev = xstdev_minus;
  }

  if (ul.getY() >= 0.0) {
    ystdev = ystdev_plus;
  } else {
    ystdev = ystdev_minus;
  }

  sum += GetPDFWithStdev(ul, xstdev, ystdev);
  sum += GetPDFWithStdev(VecPosition(br.getX(), ul.getY()), xstdev, ystdev);
  sum += GetPDFWithStdev(VecPosition(ul.getX(), br.getY()), xstdev, ystdev);
  sum += GetPDFWithStdev(br, xstdev, ystdev);
  
  //divide by 4 because we sampled 4 points
  return Min(fabs( (br.getX()-ul.getX())*(br.getY()-ul.getY())*sum) / 4.0, 1.0);
}


void Variable2DGaussian::PrintBins(float xmin, float xmax, float ymin, float ymax, bool showvals)
{
  float x,y,sum=0.0;
  for (y=ymin; y<=ymax; y+= BIN_YDIM) {
    float rowsum=0.0;
    for (x=xmin; x<=xmax; x+= BIN_XDIM) {
      float prob = GetBinPMF(VecPosition(x,y));
      sum += prob;
      rowsum += prob;
      if (showvals) cout << setw(10) << setprecision(4) << prob << " ";
    }
    if (showvals) cout << endl;
    else { 
      //cout << "Rowsum: " << rowsum << endl;
      //cout << "ygauss: " << gaussian_func(y-mean.getY(), 0.0, ystdev_plus) << endl; 
    }
  }
  cout << "Sum: " << sum << endl;
}

      
void Variable2DGaussian::PrintSimplifiedBins(ostream& out, VecPosition mark) 
{
  PrintSimplifiedBins(out,
		      -ServerParam::instance()->getSPPitchLength() / 2, ServerParam::instance()->getSPPitchLength() / 2, 
		      -ServerParam::instance()->getSPPitchWidth() / 2, ServerParam::instance()->getSPPitchWidth() / 2, 
		      1.0, 1.5,
		      mark);  
  
}
void Variable2DGaussian::PrintSimplifiedBins(ostream& out,
					     float xmin, float xmax, 
					     float ymin, float ymax, 
					     float xbinsize, float ybinsize,
					     VecPosition mark)
{
  float x,y;
  float max = GetPDF(mean);

  out << "max: " << max
      << "\tmark: (" << mark.getX() << ", " << mark.getY() << ")"
      << endl;
  for (y=ymin; y<=ymax; y+= ybinsize) {
    for (x=xmin; x<=xmax; x+= xbinsize) {
      char pr_ch;
      if (fabs(x-mark.getX()) <= xbinsize/2 && fabs(y-mark.getY()) <= ybinsize/2) {
	pr_ch = '*';
      } else {
	float pr = GetPDF(VecPosition(x,y)) / max;
	pr_ch = (int)floor(pr * 10) + '0';;
      }
      
      out << pr_ch;
    }
    out << endl;
  }
}

VecPosition Variable2DGaussian::GenerateSample()
{
  VecPosition ret(gaussian_sample_twosided(mean.getX(), xstdev_minus, xstdev_plus),
	     gaussian_sample_twosided(mean.getY(), ystdev_minus, ystdev_plus));
  
  return ret.rotate(rot_ang);
}


/***************************** PlayerDistribution ***************************/


void PlayerDistribution::setInitial(VecPosition* initPos)
{
  for (int i=0; i<NUM_PLAYERS; i++) {
    setInitialForPlayer(i+1, initPos[i]);
  }
}

void PlayerDistribution::setInitialForPlayer(int num, VecPosition initPos)
{
  player_dist[num-1].SetMean(initPos);
  player_dist[num-1].SetXStdev(.3,.3);
  player_dist[num-1].SetYStdev(.3,.3);
  player_dist[num-1].SetRotAng(0.0);
}

double PlayerDistribution::getValue(int player, VecPosition pt)
{
  //return player_dist[player-1].GetBinPMFSimple(pt);
  //return player_dist[player-1].GetPDF(pt);
  return player_dist[player-1].GetBinPMF(pt);
}

void PlayerDistribution::clear(void)
{
  for (int i=0; i<NUM_PLAYERS; i++) 
    player_dist[i].clear();
}

void PlayerDistribution::copyFrom(PlayerDistribution* master)
{
  if (this == master)
    return;
  for (int i=0; i<NUM_PLAYERS; i++) 
    player_dist[i] = master->player_dist[i];
}

float PlayerDistribution::getSumOcc(VecPosition pt)
{
  float sum = 0.0;
  
  for (int i=0; i<NUM_PLAYERS; i++) 
    sum += player_dist[i].GetPDF(pt);
  
  return sum;
}

float PlayerDistribution::getOffsidesLine(bool amILeft)
{
  RecordBestN bnLoc(2);
  
  if (amILeft) {
    for (int i=ServerParam::instance()->getSPTeamSize(); i>=1; i--) {
      bnLoc.AddPoint(NULL, player_dist[i-1].GetMean().getX());
      actionlog(260) << "PD:getOffsidesLine; Left, added: " << player_dist[i-1].GetMean().getX() << ende;
    }
    //gets the second best
    return Max(0.0, bnLoc.GetBestScore(1));
  } else {
    //we do minus to have RecordBestN record the most negative
    for (int i=ServerParam::instance()->getSPTeamSize(); i>=1; i--) {
      bnLoc.AddPoint(NULL, -player_dist[i-1].GetMean().getX());
      actionlog(260) << "PD:getOffsidesLine; Right, added: " <<  -player_dist[i-1].GetMean().getX() << ende;
    }
    //gets the second best
    return Min(0.0, -bnLoc.GetBestScore(1));
  }
  
  errorlog << "How did I get here?" << ende;
  return 0.0;
}

void PlayerDistribution::PrintAllDistSimplified(ostream& out, PlayerDistribution* pMark)
{
  for (int i=1; i<=ServerParam::instance()->getSPTeamSize(); i++) {
    out << "Player " << i << endl;
    if (pMark) 
      player_dist[i-1].PrintSimplifiedBins(out, 
					   -ServerParam::instance()->getSPPitchLength() / 2, ServerParam::instance()->getSPPitchLength() / 2, 
					   -ServerParam::instance()->getSPPitchWidth() / 2, ServerParam::instance()->getSPPitchWidth() / 2, 
					   1.0, pMark->getPlayDist(i)->GetMean());
    else
      player_dist[i-1].PrintSimplifiedBins(out, 
					   -ServerParam::instance()->getSPPitchLength() / 2, ServerParam::instance()->getSPPitchLength() / 2, 
					   -ServerParam::instance()->getSPPitchWidth() / 2, ServerParam::instance()->getSPPitchWidth() / 2, 
					   1.0);
  }
}














