/* -*- Mode: C++ -*- */

/* This is the module that controls the various functions */

#ifndef _PLANNER_CONTROLLER_H__
#define _PLANNER_CONTROLLER_H__

#include "Monitor.h"
#include "Diagnosis.h"
#include "Executor.h"
#include "Planner.h"
#include "Plan.h"
#include "Problem.h"

/* note that all of the stuff that is passed in (Monitor, defaultPlan, Problem, etc)
   and passed by reference and are *not* copied */

//the maximum number of any 1 module
const int PC_max_num_modules = 5;

/* Here is how multiple modules are handled:
   Monitor: run in sequnece; if one returns DR_Deviation, then diagnosis called, 
            then continue running the monitors
   Diagnosis: run in sequence until one returns something other than DR_Failure
   Planner: run in sequnce until one returns something other than PlnRet_Failure
   Executor: run in sequence unless one returns ER_Error
*/
/* Note that asynchronous modules are not handled correctly yet */

/* the return type for the planner controller */
enum PCReturn_t {
  PCR_Normal,
  PCR_Complete,
  PCR_Error,
  PCR_Abort
};


  
class PlannerController {
public:
  // constructors
  PlannerController();  
  PlannerController(Monitor*, Diagnosis*, Planner*, Executor*, Plan* defPlan);
  ~PlannerController();
    
  // public utility functions	
  bool addMonitor(Monitor*);
  bool addDiagnosis(Diagnosis*);
  bool addPlanner(Planner*);
  bool addExecutor(Executor*);

  void setDefaultPlan(Plan * defPlan);  
  const Plan* getDefaultPlan() { return defaultPlan; }
  void forgetDefaultPlan() 
  { defaultPlan = NULL; initDefaultPlan(); }

  void setProblem(Problem *);
  Problem* getProblem(void) {return problem;};
  void forgetProblem() 
  { problem = NULL; }

  void setRePlanFlag(bool flag) {this->rePlan = flag;};

  //starts up the PlanExecution for the default plan
  void initDefaultPlan();  

  PlanExecution* getPlanExec() { return thePlanExec; }
  PlanExecution* getDefPlanExec() { return defaultPlanExec; }

  PCReturn_t run();
    
protected:
  bool rePlan; //set this flag when the planner should be called	

  Diagnosis* diagnosis_list[PC_max_num_modules];
  Monitor* monitor_list[PC_max_num_modules];
  Planner* planner_list[PC_max_num_modules];
  Executor* executor_list[PC_max_num_modules];

  //this will be used while the planner is busy, or when we don't know what else to do
  Plan* defaultPlan; 
  PlanExecution* defaultPlanExec;  

  Plan* thePlan;
  PlanExecution* thePlanExec;  
  
  Problem* problem;

private:
  void const_helper();
  bool run_planner(PlanExecution** ppPE) ;  
  
};

#endif // _PLANNER_CONTROLLER_H__
