/* -*- Mode: C++ -*- */

/* this is a base class on which planners inherit */

#ifndef _PLANNER_H_	
#define _PLANNER_H_ 

#include "ControllerFunction.h"
#include "Plan.h"
#include "Problem.h"

enum planner_return_t {
  PlnRet_None,
  PlnRet_Complete,
  PlnRet_Failure,
  PlnRet_NotReadyYet,
};



class Planner : public ControllerFunction {
public:
  Planner() : ControllerFunction("Planner") {};  

  virtual planner_return_t run(Problem* theProblem, Plan* thePlan) = 0;

  virtual void* asynch_worker() = 0;

};

#endif 
