/* -*- Mode: C++ -*- */

/* The class which represents the current execution state of a plan */

/* form currently undecided */

#ifndef _PLAN_EXECUTION_H_	
#define _PLAN_EXECUTION_H_ 

#include <stream.h>
#include "Plan.h"
#include "types.h"
#include "Executor.h"
#include "types.h"
#include "Problem.h"
#include "CoachMessageQueue.h"

class CM_DefineToken; //defined in coach_lang_comp.h
class CM_Token; //defined in coach_lang_comp.h


enum NodeStatus_t {
  NS_NoValue,
  NS_Pending, //waiting for precursor events to finish
  NS_Ready, //ready to be executed
  NS_Complete, //already been executed,
};



class PlanExecution
{
 public:
  PlanExecution();
  //PlanExecution(Plan*);  
  ~PlanExecution();

  void Reset(); //reset the execution
  void Clear(); //removes the current plan
  //Note this class will *not* delete either the plan or the problem
  void Load(Plan* p, Problem* prob); //loads a new plan for the plan execution

  Plan* GetUnderlyingPlan() { return thePlan; }
  Problem* GetUnderlyingProblem() { return theProblem; }
  PlanNode* GetPlanNode(int idx) 
  { return (thePlan) ? thePlan->GetPlanNode(idx) : NULL; }

  /* below are things that are more specific to the particular plan 
     format which we are using */
  //execution is resposible for clearing this when it wants
  bool fresh_plan; //whether this plan was just loaded

  void SetResetOnLoad(bool b) { callResetOnLoad = b; }
  bool GetResetOnLoad() { return callResetOnLoad; }

  //returns -1 if the player is all done
  //Unum_Unknown returns first for any player
  int GetPlayerActiveNode(Unum num, int start_node = 0);
  //gets the index of (a) node which is stopping node_num from being Ready
  //returns -1 if node not pending, or if no node is holding it
  int GetNodeHolding(int node_num);

  NodeStatus_t GetNodeStatus(int idx) { return node_status[idx]; }
  void SetNodeStatus(int idx, NodeStatus_t stat) { node_status[idx] = stat; }
  int GetNodeExecTime(int idx) { return node_exec_time[idx]; }
  //propogates the info to lower and upper bounds
  //IMPORTANT: Execution times will be stored in global terms
  void SetNodeExecTime(int idx, int t);

  //IMPORTANT: Until node 0 is executed, these are relative to node 0's exec time
  // after that, however, the upper and lower bounds are for the global clock
  int GetLowerExecBound(int idx) { return lower_exec_bound[idx]; }
  int GetUpperExecBound(int idx) { return upper_exec_bound[idx]; }

  //check if there is still *some* valid times for execution of events
  bool CheckConsistency();

  void MakeNodesReady(int time);  

  int getCurrentTime() const { return curr_time; }
  void setCurrentTime(int t) { curr_time = t; }
  
#ifdef NO_ACTION_LOG
  void LogBounds(int level) {}
#else
  void LogBounds(int level);
#endif //NO_ACTION_LOG

  VecPosition GetExtraNodeInfo(int node_num) const 
  { return extra_node_info[node_num]; }
  void SetExtraNodeInfo(int node_num, VecPosition v) 
  { extra_node_info[node_num] = v; }
  void ClearExtraNodeInfo();  

  bool StandardLanguageSetup(CoachMessageQueue* pQueue);
  bool StandardLanguageStartPlan(CoachMessageQueue* pQueue);
  bool ConvertToStandardLanguage(CoachMessageQueue* pQueue);
  // returns whether any rules were deleted
  bool StandardLanguageDeleteAll(CoachMessageQueue* pQueue);
  
protected:
  Plan* thePlan;  
  Problem* theProblem;

  bool callResetOnLoad;
  
  void ClearNodeInfo();

  NodeStatus_t node_status[Plan_max_num_nodes];
  int         node_exec_time[Plan_max_num_nodes];    

  int lower_exec_bound[Plan_max_num_nodes];
  int upper_exec_bound[Plan_max_num_nodes];
 
  VecPosition extra_node_info[Plan_max_num_nodes];  

  int curr_time;
  
  bool ConvertToStandardLanguage_Start(CoachMessageQueue* pQueue);

  void addStandardLanguageRule(const std::string& prefix,
			       rcss::clang::Rule* rule,
			       CoachMessageQueue* pQueue);
  int curr_rule_id;
  rcss::clang::RuleIDList setplay_rule_id_list;
  
  static const std::string NAME_PREFIX;
  static const std::string NAME_INIT_POS_COND_PREFIX;
  static const std::string NAME_STOP_RULE;
  static const std::string NAME_GOALIE_NO_GK_RULE;
};

#endif 
