/* -*- Mode: C++ -*- */

#ifndef _OppModelSet_h_
#define _OppModelSet_h_

#include <stdlib.h>
#include <iostream.h>
//#include <cmath>
//#include <cstdlib>
//#include <vector>

#include "MovementObservation.h"
#include "OppModel.h"
#include "data.h"
#include "LogDouble.h"

class OppModelSet {

  //This class maintains the probability distribution over the set of
  //models.  It performs all the calculations of probability based
  //on given observations.

 private:
  int numModels;
  LogDouble* probs;
  OppModel** model;
  //the probability of model[i] is stored in probs[i]

  //calculate the weight based on distance to be applied to the
  //calculated probabilities
  double weight(double distance);

  //update the probability of <model> in the distribution
  void setProb(int model, double newValue);
  void multProb(int model, double newValue);

  int stored_best_OM;


 public:

  //intialize the OppModelSet
  OppModelSet(void);

  ~OppModelSet(void);

  //calculate the probabilities for each model of a certain
  //observation <o>
  void calculate(MovementObservation* o, 
		 PlayerDistribution* before,
		 PlayerDistribution *after,
		 ostream* pDistOut = NULL);

  void printProbs(ostream& out);  
  void printProbs() {printProbs(cout);}  
  void printCompactProbs(ostream& out);  
  void printCompactProbs() {printProbs(cout);}  
  void logProbs(int level);

  void setPriorProbs(double* priors);

  void addOM(OppModel* om, double prob);

  int getNumModels() { return numModels; }
  
  //normalize the distribution
  //also updates stored_best_OM
  void normalize(void);
  void setToUniform();
  
  OppModel* getOM(int index);
  OppModel* getBestOM();

  int getProbs(double* storage);

  void forgetAll() { numModels = 0; }

  /* calculates the probability that the correct model is the most likely
     after num_samples dsitributions sampled from the actual gaussians
     returned by the models */
  /* note that this destroys the current probabilities */
  MaxMeanSummary calculateProbCorrect(int num_samples, int correct_model,
				      MovementObservation* o);

};

#endif
