#ifndef _MovementObservation_h_
#define _MovementObservation_h_

#include <stdlib.h>
#include <iostream.h>

#include "BallMovement.h"
#include "OppModel.h"


class MovementObservation {

 private:
  VecPosition* start;
  VecPosition* end;
  int time;
  BallMovement* bm;
  
 public:
  MovementObservation(void);
  MovementObservation(VecPosition* st, VecPosition* ed,
		      int t, BallMovement* ball);
  ~MovementObservation(void);
  int getTime(void) { return time; }
  BallMovement* getBallMovement(void);
  VecPosition* getStartLocs(void);
  VecPosition* getEndLocs(void);
  void setTime(const int t);
  void setBallMovement(BallMovement* ball);
  void setLocations(VecPosition* st, VecPosition* ed);
  void setStartLocation(int player, VecPosition pos);
  void setEndLocation(int player, VecPosition pos);
  VecPosition getStartLocation(int player);
  VecPosition getEndLocation(int player);

  void GenerateFakeEndPos(OppModel *pOM);
  void GenerateFakeEndPos(PlayerDistribution* pDist);
};

#endif
